/*
 * Decompiled with CFR 0.152.
 */
package ttftcuts.atg.gen;

import java.util.Random;
import ttftcuts.atg.gen.ATGGenLayer;
import ttftcuts.atg.gen.ATGPerlin;

public class ATGGenLayerRarity
extends ATGGenLayer {
    private Random rand;
    private ATGPerlin[] rareNoise;

    public ATGGenLayerRarity(Long seed) {
        super(seed);
        this.func_75903_a(seed * 32857482L + 32985720342L, seed * 4985472834L + 1639572824L);
        this.rand = new Random((long)this.func_75902_a(1000000000) * seed);
        this.rareNoise = new ATGPerlin[5];
        this.rareNoise[1] = new ATGPerlin(this.rand, 931.0);
        this.rareNoise[2] = new ATGPerlin(this.rand, 243.0);
        this.rareNoise[3] = new ATGPerlin(this.rand, 53.0);
    }

    private double getRarity(int x, int z) {
        double t1 = this.rareNoise[1].normNoise(x, z, 0.0);
        double t2 = this.rareNoise[2].normNoise(x, z, 0.0);
        double t3 = this.rareNoise[3].normNoise(x, z, 0.0);
        double rarity = (t1 * 0.7 + t2 * 0.25 + t3 * 0.05) * 1.15;
        return Math.max(0.0, rarity * rarity);
    }

    public int[] func_75904_a(int x, int z, int w, int h) {
        int[] data = new int[w * h];
        for (int dz = 0; dz < h; ++dz) {
            for (int dx = 0; dx < w; ++dx) {
                this.func_75903_a(x + dx, z + dz);
                int X = x + dx;
                int Z = z + dz;
                double temp = this.getRarity(X, Z);
                data[dx + dz * w] = 1 + (int)(temp * 255.0);
            }
        }
        return data;
    }

    @Override
    public int getInt(int x, int z) {
        return 1 + (int)(this.getRarity(x, z) * 255.0);
    }

    @Override
    public double getDouble(int x, int z) {
        return this.getRarity(x, z);
    }
}

