/*
 * Decompiled with CFR 0.152.
 */
package ttftcuts.atg.gen;

import com.google.common.base.Optional;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import ttftcuts.atg.api.IGenMod;
import ttftcuts.atg.config.configfiles.ATGBiomeConfig;

public class ATGBiomeMod {
    public Map<BiomeGenBase, Double> subBiomes;
    public NavigableMap<Double, BiomeGenBase> subBiomesFinal;
    public double totalSubWeight = 0.0;
    public Optional<IGenMod> genMod = Optional.absent();

    public ATGBiomeMod() {
        this.subBiomes = new TreeMap<BiomeGenBase, Double>(new Comparator<BiomeGenBase>(){

            @Override
            public int compare(BiomeGenBase o1, BiomeGenBase o2) {
                return o1.field_76756_M > o2.field_76756_M ? 1 : -1;
            }
        });
    }

    private void process() {
        if (this.subBiomesFinal == null) {
            this.subBiomesFinal = new TreeMap<Double, BiomeGenBase>();
            this.totalSubWeight = 0.0;
            for (Map.Entry<BiomeGenBase, Double> entry : this.subBiomes.entrySet()) {
                if (!ATGBiomeConfig.generate[entry.getKey().field_76756_M].getBoolean(true) || !(ATGBiomeConfig.biomeChance[entry.getKey().field_76756_M].getDouble(1.0) > 0.0)) continue;
                this.totalSubWeight += entry.getValue() * ATGBiomeConfig.biomeChance[entry.getKey().field_76756_M].getDouble(1.0);
                this.subBiomesFinal.put(this.totalSubWeight, entry.getKey());
            }
            this.totalSubWeight += 1.0;
        }
    }

    public BiomeGenBase getSubBiome(double random) {
        if (this.subBiomes.isEmpty()) {
            return null;
        }
        this.process();
        Map.Entry<Double, BiomeGenBase> entry = this.subBiomesFinal.ceilingEntry(random * this.totalSubWeight);
        return entry != null ? entry.getValue() : null;
    }

    public ATGBiomeMod addSubBiome(BiomeGenBase biome, double weight) {
        if (!this.subBiomes.containsKey(biome)) {
            this.subBiomes.put(biome, weight);
        } else {
            this.subBiomes.put(biome, this.subBiomes.get(biome) + weight);
        }
        return this;
    }

    public ATGBiomeMod addGenMod(IGenMod mod) {
        this.genMod = Optional.of((Object)mod);
        return this;
    }

    public int modify(World world, int height, Random random, double rawHeight, int x, int z) {
        if (this.genMod.isPresent()) {
            return ((IGenMod)this.genMod.get()).modify(world, height, random, rawHeight, x, z);
        }
        return height;
    }

    public double noiseFactor() {
        if (this.genMod.isPresent()) {
            return ((IGenMod)this.genMod.get()).noiseFactor();
        }
        return 1.0;
    }
}

