/*
 * Decompiled with CFR 0.152.
 */
package ttftcuts.atg.config.configfiles;

import java.io.File;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ATGBiomeConfig {
    public static Configuration config;
    public static Property[] biomeChance;
    public static Property[] generate;

    public static void init(File configfile) {
        config = new Configuration(configfile);
        try {
            config.load();
        }
        catch (Exception e) {
            System.out.println("ATG: Failed to load biome config!");
        }
    }

    public static void postInit() {
        BiomeGenBase[] biomeList = BiomeGenBase.func_150565_n();
        for (int i = 0; i < 256; ++i) {
            if (biomeList[i] == null) continue;
            BiomeGenBase biome = biomeList[i];
            String savename = ATGBiomeConfig.getSaveNameFromBiome(biome);
            ATGBiomeConfig.biomeChance[biome.field_76756_M] = config.get(savename, "OccuranceMultiplier", 1.0);
            ATGBiomeConfig.generate[biome.field_76756_M] = config.get(savename, "Enable", true);
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static boolean domainCheck(String domain) {
        return domain.equals("net") || domain.equals("com") || domain.equals("org");
    }

    public static String getSaveNameFromBiome(BiomeGenBase b) {
        String[] parts = b.getClass().getName().split("[.]");
        String out = parts[0];
        if (ATGBiomeConfig.domainCheck(parts[0])) {
            out = parts[1];
        }
        out = out + "." + b.field_76791_y;
        return out;
    }

    public static BiomeGenBase getBiomeFromSaveName(String savename) {
        String[] saveparts = savename.split("[.]");
        BiomeGenBase[] biomeList = BiomeGenBase.func_150565_n();
        for (int i = 0; i < biomeList.length; ++i) {
            BiomeGenBase biome = biomeList[i];
            if (biome == null) continue;
            String[] parts = biome.getClass().getName().split("[.]");
            String domain = parts[0];
            if (ATGBiomeConfig.domainCheck(parts[0])) {
                domain = parts[1];
            }
            if (!domain.equals(saveparts[0]) || !saveparts[1].equals(biome.field_76791_y)) continue;
            return biome;
        }
        return null;
    }

    static {
        biomeChance = new Property[256];
        generate = new Property[256];
    }
}

