/**
 * Copyright 2014 Yamato
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package mod.ymt.air.net;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import mod.ymt.air.AirCraftCore;
import mod.ymt.air.cmn.fml.AbstractPacket;

/**
 * @author Yamato
 *
 */
public class PacketKeyHandling extends AbstractPacket {
	private String playerName;
	private byte key;
	
	public PacketKeyHandling() {
		this("", (byte) 0);
	}
	
	public PacketKeyHandling(String playerName, byte key) {
		this.playerName = playerName;
		this.key = key;
	}

	@Override
	public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
		ByteBufUtils.writeUTF8String(buffer, playerName);
		buffer.writeByte(key);
	}
	
	@Override
	public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
		playerName = ByteBufUtils.readUTF8String(buffer);
		key = buffer.readByte();
	}
	
	@Override
	public void handleClientSide(EntityPlayer player) {
		AirCraftCore.getInstance().processMoveClient(key, playerName);
	}
	
	@Override
	public void handleServerSide(EntityPlayer player) {
		AirCraftCore.getInstance().net.sendToClient(this); // サーバに届いたパケットを全クライアントへ転送
		AirCraftCore.getInstance().processMoveServer(key, playerName);
	}
}
