/**
 * Copyright 2014 Yamato
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package mod.ymt.air.cmn.fml;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;

/**
 * @author Yamato
 *
 */
public abstract class AbstractPacket {
	/**
	 * パケットのデータをByteBufに変換する. 複雑なデータ（NBTとか）はハンドラーが用意されている ( @link{cpw.mods.fml.common.network.ByteBuffUtils}を見てくれ)
	 *
	 * @param ctx    channel context（和訳注：殆ど使わない）
	 * @param buffer 変換するByteBufの変数。これにwriteしていく。
	 */
	public abstract void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer);
	
	/**
	 * ByteBufからデータを取り出す. 複雑なデータはハンドラーが用意されている ( @link{cpw.mods.fml.common.network.ByteBuffUtils}を見てくれ)
	 *
	 * @param ctx    channel context（普段は使わない）
	 * @param buffer データを取り出すByteBuf。これからreadしていく。
	 */
	public abstract void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer);
	
	/**
	 * クライアント側でパケットを受け取った後処理するメソッド。decodeIntoでByteBufが読み出されたあとに実行される。
	 *
	 * @param player the player reference
	 */
	public abstract void handleClientSide(EntityPlayer player);
	
	/**
	 * サーバー側でパケットを受け取った後処理するメソッド。decodeIntoでByteBufが読み出されたあとに実行される。
	 *
	 * @param player the player reference
	 */
	public abstract void handleServerSide(EntityPlayer player);
}
