/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.common.util;

import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mods.betterfoliage.loader.DeobfHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenBase;

public class Utils {
    private Utils() {
    }

    public static Map<String, IResourceManager> getDomainResourceManagers() {
        IResourceManager manager = Minecraft.func_71410_x().func_110442_L();
        Map result = Utils.getField(manager, DeobfHelper.transformElementSearge("domainResourceManagers"), Map.class);
        if (result == null) {
            result = Utils.getField(manager, "domainResourceManagers", Map.class);
        }
        return result;
    }

    public static <T> T getField(Object target, String fieldName, Class<T> resultClass) {
        try {
            Field field = target.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return (T)field.get(target);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T getStaticField(Class<?> clazz, String fieldName, Class<T> resultClass) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return (T)field.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ISimpleBlockRenderingHandler getRenderingHandler(int renderType) {
        try {
            Field field = RenderingRegistry.class.getDeclaredField("INSTANCE");
            field.setAccessible(true);
            RenderingRegistry inst = (RenderingRegistry)field.get(null);
            field = RenderingRegistry.class.getDeclaredField("blockRenderers");
            field.setAccessible(true);
            return (ISimpleBlockRenderingHandler)((Map)field.get(inst)).get(renderType);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean resourceExists(ResourceLocation resourceLocation) {
        try {
            IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation);
            if (resource != null) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static void copyFromTextResource(ResourceLocation resourceLocation, File target) throws IOException {
        IResource defaults = Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation);
        BufferedReader reader = new BufferedReader(new InputStreamReader(defaults.func_110527_b(), Charsets.UTF_8));
        FileWriter writer = new FileWriter(target);
        String line = reader.readLine();
        while (line != null) {
            writer.write(line + System.lineSeparator());
            line = reader.readLine();
        }
        reader.close();
        writer.close();
    }

    public static void stripTooltipDefaultText(List<String> tooltip) {
        boolean defaultRows = false;
        Iterator<String> iter = tooltip.iterator();
        while (iter.hasNext()) {
            if (iter.next().startsWith(EnumChatFormatting.AQUA.toString())) {
                defaultRows = true;
            }
            if (!defaultRows) continue;
            iter.remove();
        }
    }

    public static Predicate<BiomeGenBase> biomeTempRainFilter(final Float minTemp, final Float maxTemp, final Float minRain, final Float maxRain) {
        return new Predicate<BiomeGenBase>(){

            public boolean apply(BiomeGenBase biome) {
                if (minTemp != null && biome.field_76750_F < minTemp.floatValue()) {
                    return false;
                }
                if (maxTemp != null && biome.field_76750_F > maxTemp.floatValue()) {
                    return false;
                }
                if (minRain != null && biome.field_76751_G < minRain.floatValue()) {
                    return false;
                }
                return maxRain == null || !(biome.field_76751_G > maxRain.floatValue());
            }
        };
    }

    public static Predicate<BiomeGenBase> biomeClassFilter(final Class<?> ... classList) {
        return new Predicate<BiomeGenBase>(){

            public boolean apply(BiomeGenBase biome) {
                for (Class clazz : classList) {
                    if (!clazz.isAssignableFrom(biome.getClass()) && !clazz.equals(biome.getClass())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<BiomeGenBase> biomeClassNameFilter(final String ... names) {
        return new Predicate<BiomeGenBase>(){

            public boolean apply(BiomeGenBase biome) {
                for (String name : names) {
                    if (!biome.getClass().getName().toLowerCase().contains(name.toLowerCase())) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

