/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.resource;

import com.google.common.collect.Sets;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.Map;
import mods.betterfoliage.BetterFoliage;
import mods.betterfoliage.client.BetterFoliageClient;
import mods.betterfoliage.common.config.Config;
import mods.betterfoliage.common.util.Utils;
import mods.betterfoliage.loader.DeobfHelper;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;

@SideOnly(value=Side.CLIENT)
public class LeafTextureEnumerator
implements IIconRegister {
    public TextureMap blockTextures;

    public IIcon func_94245_a(String resourceLocation) {
        TextureAtlasSprite original = this.blockTextures.getTextureExtry(resourceLocation);
        MinecraftForge.EVENT_BUS.post((Event)new LeafTextureFoundEvent(this.blockTextures, original));
        BetterFoliage.log.debug(String.format("Found leaf texture: %s", resourceLocation));
        return original;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleTextureReload(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() != 0) {
            return;
        }
        this.blockTextures = event.map;
        BetterFoliage.log.info("Reloading leaf textures");
        for (Block block : Block.field_149771_c) {
            if (!Config.leaves.matchesClass(block)) continue;
            BetterFoliage.log.debug(String.format("Inspecting leaf block: %s", block.getClass().getName()));
            block.func_149651_a((IIconRegister)this);
        }
        Map mapAtlas = null;
        mapAtlas = Utils.getField(this.blockTextures, DeobfHelper.transformElementSearge("mapRegisteredSprites"), Map.class);
        if (mapAtlas == null) {
            mapAtlas = Utils.getField(this.blockTextures, "mapRegisteredSprites", Map.class);
        }
        if (mapAtlas == null) {
            BetterFoliage.log.warn("Failed to reflect texture atlas, textures may be missing");
        } else {
            HashSet foundLeafTextures = Sets.newHashSet();
            for (TextureAtlasSprite icon : mapAtlas.values()) {
                if (!BetterFoliageClient.isLeafTexture(icon)) continue;
                foundLeafTextures.add(icon);
            }
            for (TextureAtlasSprite icon : foundLeafTextures) {
                BetterFoliage.log.debug(String.format("Found non-block-registered leaf texture: %s", icon.func_94215_i()));
                MinecraftForge.EVENT_BUS.post((Event)new LeafTextureFoundEvent(this.blockTextures, icon));
            }
        }
    }

    @SubscribeEvent
    public void endTextureReload(TextureStitchEvent.Post event) {
        if (event.map.func_130086_a() != 0) {
            return;
        }
        this.blockTextures = null;
    }

    @SideOnly(value=Side.CLIENT)
    public static class LeafTextureFoundEvent
    extends Event {
        public TextureMap blockTextures;
        public TextureAtlasSprite icon;

        private LeafTextureFoundEvent(TextureMap blockTextures, TextureAtlasSprite icon) {
            this.blockTextures = blockTextures;
            this.icon = icon;
        }
    }
}

