/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.resource;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Map;
import javax.imageio.ImageIO;
import mods.betterfoliage.client.render.IconSet;
import mods.betterfoliage.client.resource.LeafTextureEnumerator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;

@SideOnly(value=Side.CLIENT)
public class LeafParticleTextures {
    public IconSet icons = new IconSet("betterfoliage", "falling_leaf_default_%d");
    public Map<IIcon, Integer> colors = Maps.newHashMap();
    public int defaultColor = 2129984;

    public LeafParticleTextures(int defaultColor) {
        this.defaultColor = defaultColor;
    }

    public int getColor(IIcon icon) {
        Integer result = this.colors.get(icon);
        return result == null ? this.defaultColor : result;
    }

    protected void addAtlasTexture(TextureAtlasSprite icon) {
        ResourceLocation locationNoDirs = new ResourceLocation(icon.func_94215_i());
        ResourceLocation locationWithDirs = new ResourceLocation(locationNoDirs.func_110624_b(), String.format("textures/blocks/%s.png", locationNoDirs.func_110623_a()));
        try {
            BufferedImage image = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(locationWithDirs).func_110527_b());
            int numOpaque = 0;
            float sumHueX = 0.0f;
            float sumHueY = 0.0f;
            float sumSaturation = 0.0f;
            float sumBrightness = 0.0f;
            for (int x = 0; x < image.getWidth(); ++x) {
                for (int y = 0; y < image.getHeight(); ++y) {
                    int pixel = image.getRGB(x, y);
                    int alpha = pixel >> 24 & 0xFF;
                    float[] hsbVals = Color.RGBtoHSB(pixel >> 16 & 0xFF, pixel >> 8 & 0xFF, pixel & 0xFF, null);
                    if (alpha != 255) continue;
                    ++numOpaque;
                    sumHueX = (float)((double)sumHueX + Math.cos(((double)hsbVals[0] - 0.5) * 2.0 * Math.PI));
                    sumHueY = (float)((double)sumHueY + Math.sin(((double)hsbVals[0] - 0.5) * 2.0 * Math.PI));
                    sumSaturation += hsbVals[1];
                    sumBrightness += hsbVals[2];
                }
            }
            float avgHue = (float)(Math.atan2(sumHueY, sumHueX) / (Math.PI * 2) + 0.5);
            this.colors.put((IIcon)icon, Color.HSBtoRGB(avgHue, sumSaturation / (float)numOpaque, sumBrightness / (float)numOpaque));
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void handleTextureReload(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() != 0) {
            return;
        }
        this.colors.clear();
        this.icons.registerIcons((IIconRegister)event.map);
    }

    @SubscribeEvent
    public void handleRegisterTexture(LeafTextureEnumerator.LeafTextureFoundEvent event) {
        this.addAtlasTexture(event.icon);
    }
}

