/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.resource;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mods.betterfoliage.BetterFoliage;
import mods.betterfoliage.common.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;

@SideOnly(value=Side.CLIENT)
public abstract class BlockTextureGenerator
implements IResourceManager {
    public String domainName;
    public ResourceLocation missingResource;
    public TextureMap blockTextures;

    public BlockTextureGenerator(String domainName, ResourceLocation missingResource) {
        this.domainName = domainName;
        this.missingResource = missingResource;
    }

    @SubscribeEvent
    public void handleTextureReload(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() != 0) {
            return;
        }
        this.blockTextures = event.map;
        Map<String, IResourceManager> domainManagers = Utils.getDomainResourceManagers();
        if (domainManagers == null) {
            BetterFoliage.log.warn("Failed to inject texture generator");
            return;
        }
        domainManagers.put(this.domainName, this);
    }

    @SubscribeEvent
    public void endTextureReload(TextureStitchEvent.Post event) {
        this.blockTextures = null;
        if (event.map.func_130086_a() != 0) {
            return;
        }
        Map<String, IResourceManager> domainManagers = Utils.getDomainResourceManagers();
        if (domainManagers != null) {
            domainManagers.remove(this.domainName);
        }
    }

    public Set<String> func_135055_a() {
        return ImmutableSet.of((Object)this.domainName);
    }

    public List<IResource> func_135056_b(ResourceLocation resource) throws IOException {
        return ImmutableList.of((Object)this.func_110536_a(resource));
    }

    public IResource getMissingResource() throws IOException {
        return Minecraft.func_71410_x().func_110442_L().func_110536_a(this.missingResource);
    }

    public ResourceLocation unwrapResource(ResourceLocation wrapped) {
        return new ResourceLocation(wrapped.func_110623_a().substring(16));
    }

    protected static int blendRGB(int rgbOrig, int rgbBlend, int weightOrig, int weightBlend) {
        int r = ((rgbOrig >> 16 & 0xFF) * weightOrig + (rgbBlend >> 16 & 0xFF) * weightBlend) / (weightOrig + weightBlend);
        int g = ((rgbOrig >> 8 & 0xFF) * weightOrig + (rgbBlend >> 8 & 0xFF) * weightBlend) / (weightOrig + weightBlend);
        int b = ((rgbOrig & 0xFF) * weightOrig + (rgbBlend & 0xFF) * weightBlend) / (weightOrig + weightBlend);
        int a = rgbOrig >> 24 & 0xFF;
        int result = a << 24 | r << 16 | g << 8 | b;
        return result;
    }
}

