/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.render.impl;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.betterfoliage.BetterFoliage;
import mods.betterfoliage.client.ShadersModIntegration;
import mods.betterfoliage.client.render.IRenderBlockDecorator;
import mods.betterfoliage.client.render.IconSet;
import mods.betterfoliage.client.render.RenderBlockAOBase;
import mods.betterfoliage.common.config.Config;
import mods.betterfoliage.common.util.Double3;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.util.ForgeDirection;

@SideOnly(value=Side.CLIENT)
public class RenderBlockBetterGrass
extends RenderBlockAOBase
implements IRenderBlockDecorator {
    public IconSet grassIcons = new IconSet("bettergrassandleaves", "better_grass_long_%d");
    public IconSet snowGrassIcons = new IconSet("bettergrassandleaves", "better_grass_snowed_%d");
    public IIcon grassGenIcon;
    public IIcon snowGrassGenIcon;
    protected IIcon grassTopIcon;
    protected boolean connectXP;
    protected boolean connectXN;
    protected boolean connectZP;
    protected boolean connectZN;

    @Override
    public boolean isBlockAccepted(IBlockAccess blockAccess, int x, int y, int z, Block block, int original) {
        return Config.grass.matchesID(block);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        this.field_147845_a = world;
        this.checkConnectedGrass(x, y, z);
        this.grassTopIcon = block.func_149673_e(this.field_147845_a, x, y, z, ForgeDirection.UP.ordinal());
        this.renderWorldBlockBase(1, world, x, y, z, block, modelId, renderer);
        if (!Config.grassEnabled) {
            return true;
        }
        boolean isSnowTop = this.field_147845_a.func_147439_a(x, y + 1, z) == Blocks.field_150431_aC;
        boolean isAirTop = this.field_147845_a.func_147437_c(x, y + 1, z);
        if (isSnowTop || isAirTop) {
            int iconVariation = this.getSemiRandomFromPos(x, y, z, 0);
            int heightVariation = this.getSemiRandomFromPos(x, y, z, 1);
            double scale = Config.grassSize * 0.5;
            double halfHeight = 0.5 * (Config.grassHeightMin + this.pRand[heightVariation] * (Config.grassHeightMax - Config.grassHeightMin));
            IIcon shortGrassIcon = null;
            if (isSnowTop) {
                this.aoYPXZNN.setGray(0.9f);
                this.aoYPXZNP.setGray(0.9f);
                this.aoYPXZPN.setGray(0.9f);
                this.aoYPXZPP.setGray(0.9f);
                Tessellator.field_78398_a.func_78376_a(230, 230, 230);
                shortGrassIcon = Config.grassUseGenerated ? this.snowGrassGenIcon : this.snowGrassIcons.get(iconVariation);
            } else {
                Tessellator.field_78398_a.func_78378_d(block.func_149720_d(this.field_147845_a, x, y, z));
                IIcon iIcon = shortGrassIcon = Config.grassUseGenerated ? this.grassGenIcon : this.grassIcons.get(iconVariation);
            }
            if (shortGrassIcon == null) {
                return true;
            }
            ShadersModIntegration.startGrassQuads();
            Tessellator.field_78398_a.func_78380_c(this.getBrightness(block, x, y + 1, z));
            this.renderCrossedSideQuads(new Double3((double)x + 0.5, (double)y + 1.0 + (isSnowTop ? 0.0625 : 0.0), (double)z + 0.5), ForgeDirection.UP, scale, halfHeight, this.pRot[iconVariation], Config.grassHOffset, shortGrassIcon, 0, false);
        }
        return true;
    }

    protected void checkConnectedGrass(int x, int y, int z) {
        Block blockBelow = this.field_147845_a.func_147439_a(x, y - 1, z);
        if (Config.ctxGrassAggressiveEnabled && (Config.grass.matchesID(blockBelow) || Config.dirt.matchesID(blockBelow))) {
            this.connectXP = true;
            this.connectXN = true;
            this.connectZP = true;
            this.connectZN = true;
        } else if (Config.ctxGrassClassicEnabled) {
            this.connectXP = Config.grass.matchesID(this.field_147845_a.func_147439_a(x + 1, y - 1, z));
            this.connectXN = Config.grass.matchesID(this.field_147845_a.func_147439_a(x - 1, y - 1, z));
            this.connectZP = Config.grass.matchesID(this.field_147845_a.func_147439_a(x, y - 1, z + 1));
            this.connectZN = Config.grass.matchesID(this.field_147845_a.func_147439_a(x, y - 1, z - 1));
        } else {
            this.connectXP = false;
            this.connectXN = false;
            this.connectZP = false;
            this.connectZN = false;
        }
    }

    @Override
    public void func_147761_c(Block block, double x, double y, double z, IIcon icon) {
        super.func_147761_c(block, x, y, z, this.connectZN ? this.grassTopIcon : icon);
    }

    @Override
    public void func_147734_d(Block block, double x, double y, double z, IIcon icon) {
        super.func_147734_d(block, x, y, z, this.connectZP ? this.grassTopIcon : icon);
    }

    @Override
    public void func_147798_e(Block block, double x, double y, double z, IIcon icon) {
        super.func_147798_e(block, x, y, z, this.connectXN ? this.grassTopIcon : icon);
    }

    @Override
    public void func_147764_f(Block block, double x, double y, double z, IIcon icon) {
        super.func_147764_f(block, x, y, z, this.connectXP ? this.grassTopIcon : icon);
    }

    @SubscribeEvent
    public void handleTextureReload(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() != 0) {
            return;
        }
        this.grassIcons.registerIcons((IIconRegister)event.map);
        this.snowGrassIcons.registerIcons((IIconRegister)event.map);
        this.grassGenIcon = event.map.func_94245_a("bf_shortgrass:minecraft:tallgrass");
        this.snowGrassGenIcon = event.map.func_94245_a("bf_shortgrass_snow:minecraft:tallgrass");
        BetterFoliage.log.info(String.format("Found %d short grass textures", this.grassIcons.numLoaded));
        BetterFoliage.log.info(String.format("Found %d snowy grass textures", this.snowGrassIcons.numLoaded));
    }
}

