/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.render.impl;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.betterfoliage.BetterFoliage;
import mods.betterfoliage.client.render.FakeRenderBlockAOBase;
import mods.betterfoliage.client.render.IRenderBlockDecorator;
import mods.betterfoliage.client.render.IconSet;
import mods.betterfoliage.common.config.Config;
import mods.betterfoliage.common.util.Double3;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.util.ForgeDirection;

@SideOnly(value=Side.CLIENT)
public class RenderBlockBetterCactus
extends FakeRenderBlockAOBase
implements IRenderBlockDecorator {
    public IIcon cactusRoundIcon;
    public IconSet cactusSideIcons = new IconSet("bettergrassandleaves", "better_cactus_arm_%d");
    public static ForgeDirection[] cactusDirections = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST};
    public static double cactusRadius = 0.4375;

    @Override
    public boolean isBlockAccepted(IBlockAccess blockAccess, int x, int y, int z, Block block, int original) {
        return Config.cactusEnabled && block == Blocks.field_150434_aF;
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        this.field_147845_a = world;
        if (renderer.func_147744_b()) {
            renderer.func_147755_t(block, x, y, z);
            return true;
        }
        this.setPassCounters(1);
        this.func_147784_q(block, x, y, z);
        Double3 blockCenter = new Double3((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        Tessellator.field_78398_a.func_78380_c(this.getBrightness(block, x, y, z));
        this.renderCactusCore(block.func_149733_h(ForgeDirection.UP.ordinal()), block.func_149733_h(ForgeDirection.NORTH.ordinal()), blockCenter, 0);
        ForgeDirection drawDirection = cactusDirections[this.getSemiRandomFromPos(x, y, z, 0) % 4];
        int iconVariation = this.getSemiRandomFromPos(x, y, z, 1);
        Double3 drawBase = blockCenter.add(new Double3(drawDirection).scale(cactusRadius));
        Tessellator.field_78398_a.func_78380_c(this.getBrightness(block, x, y, z));
        if (this.cactusSideIcons.hasIcons()) {
            this.renderCrossedSideQuads(drawBase, drawDirection, 0.5, 0.5, this.pRot[iconVariation], 0.2, this.cactusSideIcons.get(iconVariation), 0, false);
        }
        this.renderCrossedBlockQuadsSkew(blockCenter, 0.65, this.pRot[iconVariation].scaleAxes(0.1, 0.0, 0.1), this.pRot[iconVariation + 1 & 0x3F].scaleAxes(0.1, 0.0, 0.1), this.cactusRoundIcon, iconVariation, false, false);
        return true;
    }

    protected void renderCactusCore(IIcon topIcon, IIcon sideIcon, Double3 blockCenter, int sideUvRot) {
        if (Minecraft.func_71379_u()) {
            this.renderQuadWithShading(sideIcon, blockCenter.add(cactusRadius, 0.0, 0.0), new Double3(0.0, 0.0, -0.5), new Double3(0.0, 0.5, 0.0), sideUvRot, this.aoXPYZPN, this.aoXPYZPP, this.aoXPYZNP, this.aoXPYZNN);
            this.renderQuadWithShading(sideIcon, blockCenter.add(-cactusRadius, 0.0, 0.0), new Double3(0.0, 0.0, 0.5), new Double3(0.0, 0.5, 0.0), sideUvRot, this.aoXNYZPP, this.aoXNYZPN, this.aoXNYZNN, this.aoXNYZNP);
            this.renderQuadWithShading(sideIcon, blockCenter.add(0.0, 0.0, cactusRadius), new Double3(0.5, 0.0, 0.0), new Double3(0.0, 0.5, 0.0), sideUvRot, this.aoZPXYPP, this.aoZPXYNP, this.aoZPXYNN, this.aoZPXYPN);
            this.renderQuadWithShading(sideIcon, blockCenter.add(0.0, 0.0, -cactusRadius), new Double3(-0.5, 0.0, 0.0), new Double3(0.0, 0.5, 0.0), sideUvRot, this.aoZNXYNP, this.aoZNXYPP, this.aoZNXYPN, this.aoZNXYNN);
            this.renderQuadWithShading(topIcon, blockCenter.add(0.0, 0.5, 0.0), new Double3(-0.5, 0.0, 0.0), new Double3(0.0, 0.0, 0.5), 0, this.aoYPXZNP, this.aoYPXZPP, this.aoYPXZPN, this.aoYPXZNN);
        } else {
            this.renderQuad(sideIcon, blockCenter.add(cactusRadius, 0.0, 0.0), new Double3(0.0, 0.0, -0.5), new Double3(0.0, 0.5, 0.0), sideUvRot);
            this.renderQuad(sideIcon, blockCenter.add(-cactusRadius, 0.0, 0.0), new Double3(0.0, 0.0, 0.5), new Double3(0.0, 0.5, 0.0), sideUvRot);
            this.renderQuad(sideIcon, blockCenter.add(0.0, 0.0, cactusRadius), new Double3(0.5, 0.0, 0.0), new Double3(0.0, 0.5, 0.0), sideUvRot);
            this.renderQuad(sideIcon, blockCenter.add(0.0, 0.0, -cactusRadius), new Double3(-0.5, 0.0, 0.0), new Double3(0.0, 0.5, 0.0), sideUvRot);
            this.renderQuad(topIcon, blockCenter.add(0.0, 0.5, 0.0), new Double3(-0.5, 0.0, 0.0), new Double3(0.0, 0.0, 0.5), 0);
        }
    }

    @SubscribeEvent
    public void handleTextureReload(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() != 0) {
            return;
        }
        this.cactusRoundIcon = event.map.func_94245_a("bettergrassandleaves:better_cactus");
        this.cactusSideIcons.registerIcons((IIconRegister)event.map);
        BetterFoliage.log.info(String.format("Found %d cactus arm textures", this.cactusSideIcons.numLoaded));
    }
}

