/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import mods.betterfoliage.common.util.Double3;
import mods.betterfoliage.common.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderBlockAOBase
extends RenderBlocks {
    protected double[] uValues = new double[]{0.0, 16.0, 16.0, 0.0};
    protected double[] vValues = new double[]{0.0, 0.0, 16.0, 16.0};
    protected ForgeDirection[] faceDir1 = new ForgeDirection[]{ForgeDirection.WEST, ForgeDirection.WEST, ForgeDirection.WEST, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.NORTH};
    protected ForgeDirection[] faceDir2 = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.UP, ForgeDirection.UP, ForgeDirection.UP, ForgeDirection.UP};
    public Double3[] pRot = new Double3[64];
    public double[] pRand = new double[64];
    public ShadingValues aoXPYZPP = new ShadingValues();
    public ShadingValues aoXPYZPN = new ShadingValues();
    public ShadingValues aoXPYZNP = new ShadingValues();
    public ShadingValues aoXPYZNN = new ShadingValues();
    public ShadingValues aoXNYZPP = new ShadingValues();
    public ShadingValues aoXNYZPN = new ShadingValues();
    public ShadingValues aoXNYZNP = new ShadingValues();
    public ShadingValues aoXNYZNN = new ShadingValues();
    public ShadingValues aoYPXZPP = new ShadingValues();
    public ShadingValues aoYPXZPN = new ShadingValues();
    public ShadingValues aoYPXZNP = new ShadingValues();
    public ShadingValues aoYPXZNN = new ShadingValues();
    public ShadingValues aoYNXZPP = new ShadingValues();
    public ShadingValues aoYNXZPN = new ShadingValues();
    public ShadingValues aoYNXZNP = new ShadingValues();
    public ShadingValues aoYNXZNN = new ShadingValues();
    public ShadingValues aoZPXYPP = new ShadingValues();
    public ShadingValues aoZPXYPN = new ShadingValues();
    public ShadingValues aoZPXYNP = new ShadingValues();
    public ShadingValues aoZPXYNN = new ShadingValues();
    public ShadingValues aoZNXYPP = new ShadingValues();
    public ShadingValues aoZNXYPN = new ShadingValues();
    public ShadingValues aoZNXYNP = new ShadingValues();
    public ShadingValues aoZNXYNN = new ShadingValues();
    public ShadingValues faceAOPP;
    public ShadingValues faceAOPN;
    public ShadingValues faceAONN;
    public ShadingValues faceAONP;

    public void init() {
        ArrayList<Double3> perturbs = new ArrayList<Double3>(64);
        for (int idx = 0; idx < 64; ++idx) {
            double angle = (double)idx * Math.PI * 2.0 / 64.0;
            perturbs.add(new Double3(Math.cos(angle), Math.random() * 2.0 - 1.0, Math.sin(angle)));
            this.pRand[idx] = Math.random();
        }
        Collections.shuffle(perturbs);
        Iterator iter = perturbs.iterator();
        for (int idx = 0; idx < 64; ++idx) {
            this.pRot[idx] = (Double3)iter.next();
        }
    }

    protected int getSemiRandomFromPos(double x, double y, double z, int seed) {
        long lx = MathHelper.func_76128_c((double)x);
        long ly = MathHelper.func_76128_c((double)y);
        long lz = MathHelper.func_76128_c((double)z);
        long value = lx * lx + ly * ly + lz * lz + lx * ly + ly * lz + lz * lx + (long)(seed * seed) & 0x3FL;
        value = 3L * lx * value + 5L * ly * value + 7L * lz * value + (long)(11 * seed) & 0x3FL;
        return (int)value;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        this.renderStandardBlockAsItem(renderer, block, metadata, 1.0f);
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return 0;
    }

    protected void renderWorldBlockBase(int pass, IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (renderer.func_147744_b()) {
            renderer.func_147775_a(block);
            renderer.func_147784_q(block, x, y, z);
            return;
        }
        this.setPassCounters(1);
        this.func_147775_a(block);
        ISimpleBlockRenderingHandler handler = Utils.getRenderingHandler(block.func_149645_b());
        if (handler != null) {
            handler.renderWorldBlock(world, x, y, z, block, block.func_149645_b(), (RenderBlocks)this);
        } else {
            this.func_147784_q(block, x, y, z);
        }
    }

    protected void renderStandardBlockAsItem(RenderBlocks renderer, Block p_147800_1_, int p_147800_2_, float p_147800_3_) {
        Tessellator tessellator = Tessellator.field_78398_a;
        boolean flag = p_147800_1_ == Blocks.field_150349_c;
        p_147800_1_.func_149683_g();
        renderer.func_147775_a(p_147800_1_);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(p_147800_1_, 0.0, 0.0, 0.0, renderer.func_147787_a(p_147800_1_, 0, p_147800_2_));
        tessellator.func_78381_a();
        if (flag && renderer.field_147844_c) {
            int k = p_147800_1_.func_149741_i(p_147800_2_);
            float f2 = (float)(k >> 16 & 0xFF) / 255.0f;
            float f3 = (float)(k >> 8 & 0xFF) / 255.0f;
            float f4 = (float)(k & 0xFF) / 255.0f;
            GL11.glColor4f((float)(f2 * p_147800_3_), (float)(f3 * p_147800_3_), (float)(f4 * p_147800_3_), (float)1.0f);
        }
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(p_147800_1_, 0.0, 0.0, 0.0, renderer.func_147787_a(p_147800_1_, 1, p_147800_2_));
        tessellator.func_78381_a();
        if (flag && renderer.field_147844_c) {
            GL11.glColor4f((float)p_147800_3_, (float)p_147800_3_, (float)p_147800_3_, (float)1.0f);
        }
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(p_147800_1_, 0.0, 0.0, 0.0, renderer.func_147787_a(p_147800_1_, 2, p_147800_2_));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(p_147800_1_, 0.0, 0.0, 0.0, renderer.func_147787_a(p_147800_1_, 3, p_147800_2_));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(p_147800_1_, 0.0, 0.0, 0.0, renderer.func_147787_a(p_147800_1_, 4, p_147800_2_));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(p_147800_1_, 0.0, 0.0, 0.0, renderer.func_147787_a(p_147800_1_, 5, p_147800_2_));
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    protected void setShadingForFace(ForgeDirection dir) {
        if (dir == ForgeDirection.DOWN) {
            this.faceAOPP = this.aoYNXZPP;
            this.faceAOPN = this.aoYNXZPN;
            this.faceAONN = this.aoYNXZNN;
            this.faceAONP = this.aoYNXZNP;
        } else if (dir == ForgeDirection.UP) {
            this.faceAOPP = this.aoYPXZPP;
            this.faceAOPN = this.aoYPXZPN;
            this.faceAONN = this.aoYPXZNN;
            this.faceAONP = this.aoYPXZNP;
        } else if (dir == ForgeDirection.NORTH) {
            this.faceAOPP = this.aoZNXYNP;
            this.faceAOPN = this.aoZNXYNN;
            this.faceAONN = this.aoZNXYPN;
            this.faceAONP = this.aoZNXYPP;
        } else if (dir == ForgeDirection.SOUTH) {
            this.faceAOPP = this.aoZPXYPP;
            this.faceAOPN = this.aoZPXYPN;
            this.faceAONN = this.aoZPXYNN;
            this.faceAONP = this.aoZPXYNP;
        } else if (dir == ForgeDirection.WEST) {
            this.faceAOPP = this.aoXNYZPP;
            this.faceAOPN = this.aoXNYZNP;
            this.faceAONN = this.aoXNYZNN;
            this.faceAONP = this.aoXNYZPN;
        } else if (dir == ForgeDirection.EAST) {
            this.faceAOPP = this.aoXPYZPN;
            this.faceAOPN = this.aoXPYZNN;
            this.faceAONN = this.aoXPYZNP;
            this.faceAONP = this.aoXPYZPP;
        }
    }

    public void renderCrossedSideQuads(Double3 drawBase, ForgeDirection dir, double scale, double halfHeight, Double3 rendomVec, double offset, IIcon renderIcon, int uvRot, boolean noShading) {
        Double3 drawCenter;
        Double3 faceNormal;
        Double3 faceNP;
        Double3 facePP;
        if (dir == ForgeDirection.UP) {
            facePP = new Double3(-scale, 0.0, scale);
            faceNP = new Double3(scale, 0.0, scale);
            faceNormal = new Double3(0.0, halfHeight, 0.0);
            drawCenter = drawBase.add(faceNormal);
            if (rendomVec != null) {
                drawCenter = drawBase.add(faceNormal).add(rendomVec.scaleAxes(-offset, 0.0, offset));
            }
        } else {
            facePP = new Double3(this.faceDir1[dir.ordinal()]).add(new Double3(this.faceDir2[dir.ordinal()])).scale(scale);
            faceNP = new Double3(this.faceDir1[dir.ordinal()]).inverse().add(new Double3(this.faceDir2[dir.ordinal()])).scale(scale);
            faceNormal = new Double3(dir).scale(halfHeight);
            drawCenter = drawBase.add(faceNormal);
            if (rendomVec != null) {
                drawCenter = drawCenter.add(new Double3(this.faceDir1[dir.ordinal()]).scale(rendomVec.x).scale(offset)).add(new Double3(this.faceDir2[dir.ordinal()]).scale(rendomVec.z).scale(offset));
            }
        }
        if (Minecraft.func_71379_u() && !noShading) {
            this.setShadingForFace(dir);
            this.renderQuadWithShading(renderIcon, drawCenter, facePP, faceNormal, uvRot, this.faceAOPP, this.faceAONN, this.faceAONN, this.faceAOPP);
            this.renderQuadWithShading(renderIcon, drawCenter, facePP.inverse(), faceNormal, uvRot, this.faceAONN, this.faceAOPP, this.faceAOPP, this.faceAONN);
            this.renderQuadWithShading(renderIcon, drawCenter, faceNP, faceNormal, uvRot, this.faceAONP, this.faceAOPN, this.faceAOPN, this.faceAONP);
            this.renderQuadWithShading(renderIcon, drawCenter, faceNP.inverse(), faceNormal, uvRot, this.faceAOPN, this.faceAONP, this.faceAONP, this.faceAOPN);
        } else {
            this.renderQuad(renderIcon, drawCenter, facePP, faceNormal, uvRot);
            this.renderQuad(renderIcon, drawCenter, facePP.inverse(), faceNormal, uvRot);
            this.renderQuad(renderIcon, drawCenter, faceNP, faceNormal, uvRot);
            this.renderQuad(renderIcon, drawCenter, faceNP.inverse(), faceNormal, uvRot);
        }
    }

    protected void renderCrossedBlockQuadsTranslate(Double3 blockCenter, double halfSize, Double3 offsetVec, IIcon crossLeafIcon, int uvRot, boolean isAirTop, boolean isAirBottom) {
        Double3 drawCenter = blockCenter;
        if (offsetVec != null) {
            drawCenter = drawCenter.add(offsetVec);
        }
        Double3 horz1 = new Double3(halfSize, 0.0, halfSize);
        Double3 horz2 = new Double3(halfSize, 0.0, -halfSize);
        Double3 vert1 = new Double3(0.0, halfSize * 1.41, 0.0);
        this.renderCrossedBlockQuadsInternal(drawCenter, horz1, horz2, vert1, crossLeafIcon, uvRot, isAirTop, isAirBottom);
    }

    protected void renderCrossedBlockQuadsSkew(Double3 blockCenter, double halfSize, Double3 offsetVec1, Double3 offsetVec2, IIcon crossLeafIcon, int uvRot, boolean isAirTop, boolean isAirBottom) {
        Double3 horz1 = new Double3(halfSize, 0.0, halfSize).add(offsetVec1);
        Double3 horz2 = new Double3(halfSize, 0.0, -halfSize).add(offsetVec2);
        Double3 vert1 = new Double3(0.0, halfSize * 1.41, 0.0);
        this.renderCrossedBlockQuadsInternal(blockCenter, horz1, horz2, vert1, crossLeafIcon, uvRot, isAirTop, isAirBottom);
    }

    private void renderCrossedBlockQuadsInternal(Double3 drawCenter, Double3 horz1, Double3 horz2, Double3 vert1, IIcon crossLeafIcon, int uvRot, boolean isAirTop, boolean isAirBottom) {
        if (Minecraft.func_71379_u()) {
            this.renderQuadWithShading(crossLeafIcon, drawCenter, horz1, vert1, uvRot, isAirTop ? this.aoYPXZPP : this.aoZPXYPP, isAirTop ? this.aoYPXZNN : this.aoXNYZPN, isAirBottom ? this.aoYNXZNN : this.aoXNYZNN, isAirBottom ? this.aoYNXZPP : this.aoZPXYPN);
            this.renderQuadWithShading(crossLeafIcon, drawCenter, horz1.inverse(), vert1, uvRot, isAirTop ? this.aoYPXZNN : this.aoZNXYNP, isAirTop ? this.aoYPXZPP : this.aoXPYZPP, isAirBottom ? this.aoYNXZPP : this.aoXPYZNP, isAirBottom ? this.aoYNXZNN : this.aoZNXYNN);
            this.renderQuadWithShading(crossLeafIcon, drawCenter, horz2, vert1, uvRot, isAirTop ? this.aoYPXZPN : this.aoXPYZPN, isAirTop ? this.aoYPXZNP : this.aoZPXYNP, isAirBottom ? this.aoYNXZNP : this.aoZPXYNN, isAirBottom ? this.aoYNXZPN : this.aoXPYZNN);
            this.renderQuadWithShading(crossLeafIcon, drawCenter, horz2.inverse(), vert1, uvRot, isAirTop ? this.aoYPXZNP : this.aoXNYZPP, isAirTop ? this.aoYPXZPN : this.aoZNXYPP, isAirBottom ? this.aoYNXZPN : this.aoZNXYPN, isAirBottom ? this.aoYNXZNP : this.aoXNYZNP);
        } else {
            this.renderQuad(crossLeafIcon, drawCenter, horz1, vert1, uvRot);
            this.renderQuad(crossLeafIcon, drawCenter, horz1.inverse(), vert1, uvRot);
            this.renderQuad(crossLeafIcon, drawCenter, horz2, vert1, uvRot);
            this.renderQuad(crossLeafIcon, drawCenter, horz2.inverse(), vert1, uvRot);
        }
    }

    public void func_147761_c(Block block, double x, double y, double z, IIcon icon) {
        super.func_147761_c(block, x, y, z, icon);
        this.saveShadingTopLeft(this.aoZNXYPP);
        this.saveShadingTopRight(this.aoZNXYNP);
        this.saveShadingBottomLeft(this.aoZNXYPN);
        this.saveShadingBottomRight(this.aoZNXYNN);
    }

    public void func_147734_d(Block block, double x, double y, double z, IIcon icon) {
        super.func_147734_d(block, x, y, z, icon);
        this.saveShadingTopLeft(this.aoZPXYNP);
        this.saveShadingTopRight(this.aoZPXYPP);
        this.saveShadingBottomLeft(this.aoZPXYNN);
        this.saveShadingBottomRight(this.aoZPXYPN);
    }

    public void func_147798_e(Block block, double x, double y, double z, IIcon icon) {
        super.func_147798_e(block, x, y, z, icon);
        this.saveShadingTopLeft(this.aoXNYZPN);
        this.saveShadingTopRight(this.aoXNYZPP);
        this.saveShadingBottomLeft(this.aoXNYZNN);
        this.saveShadingBottomRight(this.aoXNYZNP);
    }

    public void func_147764_f(Block block, double x, double y, double z, IIcon icon) {
        super.func_147764_f(block, x, y, z, icon);
        this.saveShadingTopLeft(this.aoXPYZPP);
        this.saveShadingTopRight(this.aoXPYZPN);
        this.saveShadingBottomLeft(this.aoXPYZNP);
        this.saveShadingBottomRight(this.aoXPYZNN);
    }

    public void func_147768_a(Block block, double x, double y, double z, IIcon icon) {
        super.func_147768_a(block, x, y, z, icon);
        this.saveShadingTopLeft(this.aoYNXZNP);
        this.saveShadingTopRight(this.aoYNXZPP);
        this.saveShadingBottomLeft(this.aoYNXZNN);
        this.saveShadingBottomRight(this.aoYNXZPN);
    }

    public void func_147806_b(Block block, double x, double y, double z, IIcon icon) {
        super.func_147806_b(block, x, y, z, icon);
        this.saveShadingTopLeft(this.aoYPXZPP);
        this.saveShadingTopRight(this.aoYPXZNP);
        this.saveShadingBottomLeft(this.aoYPXZPN);
        this.saveShadingBottomRight(this.aoYPXZNN);
    }

    protected void saveShadingTopLeft(ShadingValues values) {
        if (--values.passCounter != 0) {
            return;
        }
        values.brightness = this.field_147864_al;
        values.red = this.field_147872_ap;
        values.green = this.field_147846_at;
        values.blue = this.field_147854_ax;
    }

    protected void saveShadingTopRight(ShadingValues values) {
        if (--values.passCounter != 0) {
            return;
        }
        values.brightness = this.field_147870_ao;
        values.red = this.field_147848_as;
        values.green = this.field_147856_aw;
        values.blue = this.field_147833_aA;
    }

    protected void saveShadingBottomLeft(ShadingValues values) {
        if (--values.passCounter != 0) {
            return;
        }
        values.brightness = this.field_147874_am;
        values.red = this.field_147852_aq;
        values.green = this.field_147860_au;
        values.blue = this.field_147841_ay;
    }

    protected void saveShadingBottomRight(ShadingValues values) {
        if (--values.passCounter != 0) {
            return;
        }
        values.brightness = this.field_147876_an;
        values.red = this.field_147850_ar;
        values.green = this.field_147858_av;
        values.blue = this.field_147839_az;
    }

    protected void setPassCounters(int value) {
        this.aoXPYZPP.passCounter = value;
        this.aoXPYZPN.passCounter = value;
        this.aoXPYZNP.passCounter = value;
        this.aoXPYZNN.passCounter = value;
        this.aoXNYZPP.passCounter = value;
        this.aoXNYZPN.passCounter = value;
        this.aoXNYZNP.passCounter = value;
        this.aoXNYZNN.passCounter = value;
        this.aoYPXZPP.passCounter = value;
        this.aoYPXZPN.passCounter = value;
        this.aoYPXZNP.passCounter = value;
        this.aoYPXZNN.passCounter = value;
        this.aoYNXZPP.passCounter = value;
        this.aoYNXZPN.passCounter = value;
        this.aoYNXZNP.passCounter = value;
        this.aoYNXZNN.passCounter = value;
        this.aoZPXYPP.passCounter = value;
        this.aoZPXYPN.passCounter = value;
        this.aoZPXYNP.passCounter = value;
        this.aoZPXYNN.passCounter = value;
        this.aoZNXYPP.passCounter = value;
        this.aoZNXYPN.passCounter = value;
        this.aoZNXYNP.passCounter = value;
        this.aoZNXYNN.passCounter = value;
    }

    protected void renderQuad(IIcon icon, Double3 center, Double3 vec1, Double3 vec2, int uvRot) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78374_a(center.x + vec1.x + vec2.x, center.y + vec1.y + vec2.y, center.z + vec1.z + vec2.z, (double)icon.func_94214_a(this.uValues[uvRot & 3]), (double)icon.func_94207_b(this.vValues[uvRot & 3]));
        tessellator.func_78374_a(center.x - vec1.x + vec2.x, center.y - vec1.y + vec2.y, center.z - vec1.z + vec2.z, (double)icon.func_94214_a(this.uValues[uvRot + 1 & 3]), (double)icon.func_94207_b(this.vValues[uvRot + 1 & 3]));
        tessellator.func_78374_a(center.x - vec1.x - vec2.x, center.y - vec1.y - vec2.y, center.z - vec1.z - vec2.z, (double)icon.func_94214_a(this.uValues[uvRot + 2 & 3]), (double)icon.func_94207_b(this.vValues[uvRot + 2 & 3]));
        tessellator.func_78374_a(center.x + vec1.x - vec2.x, center.y + vec1.y - vec2.y, center.z + vec1.z - vec2.z, (double)icon.func_94214_a(this.uValues[uvRot + 3 & 3]), (double)icon.func_94207_b(this.vValues[uvRot + 3 & 3]));
    }

    protected void renderQuadWithShading(IIcon icon, Double3 center, Double3 vec1, Double3 vec2, int uvRot, ShadingValues aoPP, ShadingValues aoNP, ShadingValues aoNN, ShadingValues aoPN) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78380_c(aoPP.brightness);
        tessellator.func_78386_a(aoPP.red, aoPP.green, aoPP.blue);
        tessellator.func_78374_a(center.x + vec1.x + vec2.x, center.y + vec1.y + vec2.y, center.z + vec1.z + vec2.z, (double)icon.func_94214_a(this.uValues[uvRot & 3]), (double)icon.func_94207_b(this.vValues[uvRot & 3]));
        tessellator.func_78380_c(aoNP.brightness);
        tessellator.func_78386_a(aoNP.red, aoNP.green, aoNP.blue);
        tessellator.func_78374_a(center.x - vec1.x + vec2.x, center.y - vec1.y + vec2.y, center.z - vec1.z + vec2.z, (double)icon.func_94214_a(this.uValues[uvRot + 1 & 3]), (double)icon.func_94207_b(this.vValues[uvRot + 1 & 3]));
        tessellator.func_78380_c(aoNN.brightness);
        tessellator.func_78386_a(aoNN.red, aoNN.green, aoNN.blue);
        tessellator.func_78374_a(center.x - vec1.x - vec2.x, center.y - vec1.y - vec2.y, center.z - vec1.z - vec2.z, (double)icon.func_94214_a(this.uValues[uvRot + 2 & 3]), (double)icon.func_94207_b(this.vValues[uvRot + 2 & 3]));
        tessellator.func_78380_c(aoPN.brightness);
        tessellator.func_78386_a(aoPN.red, aoPN.green, aoPN.blue);
        tessellator.func_78374_a(center.x + vec1.x - vec2.x, center.y + vec1.y - vec2.y, center.z + vec1.z - vec2.z, (double)icon.func_94214_a(this.uValues[uvRot + 3 & 3]), (double)icon.func_94207_b(this.vValues[uvRot + 3 & 3]));
    }

    protected int getBrightness(Block block, int x, int y, int z) {
        return block.func_149677_c(this.field_147845_a, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public static class ShadingValues {
        public int passCounter = 0;
        public int brightness;
        public float red;
        public float green;
        public float blue;

        public void setGray(float value) {
            this.red = value;
            this.green = value;
            this.blue = value;
        }
    }
}

