/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cpw.mods.fml.client.config.ConfigGuiType;
import cpw.mods.fml.client.config.DummyConfigElement;
import cpw.mods.fml.client.config.GuiConfig;
import cpw.mods.fml.client.config.GuiConfigEntries;
import cpw.mods.fml.client.config.IConfigElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import mods.betterfoliage.common.util.Utils;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;

public abstract class SelectListConfigEntry<T>
extends GuiConfigEntries.CategoryEntry {
    List<ItemWrapperElement> children;
    List<Integer> notFoundIdList;

    public SelectListConfigEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement<?> configElement) {
        super(owningScreen, owningEntryList, configElement);
        Utils.stripTooltipDefaultText(this.toolTip);
    }

    protected GuiScreen buildChildScreen() {
        return new GuiConfig((GuiScreen)this.owningScreen, this.createChildElements(), this.owningScreen.modID, this.owningScreen.allRequireWorldRestart || this.configElement.requiresWorldRestart(), this.owningScreen.allRequireMcRestart || this.configElement.requiresMcRestart(), this.owningScreen.title, (this.owningScreen.titleLine2 == null ? "" : this.owningScreen.titleLine2) + " > " + this.name);
    }

    protected abstract List<T> getBaseSet(String var1);

    protected abstract List<T> getDefaultSelected(String var1);

    protected abstract int getItemId(T var1);

    protected abstract String getItemName(T var1);

    protected abstract String getTooltipLangKey(String var1);

    protected List<IConfigElement> createChildElements() {
        this.children = Lists.newArrayList();
        ArrayList idList = Lists.newArrayList();
        for (Object id : this.configElement.getList()) {
            idList.add((Integer)id);
        }
        List<T> defaults = this.getDefaultSelected(this.configElement.getName());
        for (T item : this.getBaseSet(this.configElement.getQualifiedName())) {
            this.children.add(new ItemWrapperElement(item, defaults.contains(item), idList.contains(this.getItemId(item))));
            idList.remove(new Integer(this.getItemId(item)));
        }
        this.notFoundIdList = idList;
        ArrayList result = Lists.newArrayList();
        result.addAll(this.children);
        return result;
    }

    public boolean saveConfigElement() {
        boolean requiresRestart = ((GuiConfig)this.childScreen).entryList.saveConfigElements();
        HashSet idSet = Sets.newHashSet();
        for (ItemWrapperElement child : this.children) {
            if (!Boolean.TRUE.equals(child.getCurrentValue())) continue;
            idSet.add(this.getItemId(child.item));
        }
        idSet.addAll(this.notFoundIdList);
        ArrayList result = Lists.newArrayList((Iterable)idSet);
        Collections.sort(result);
        this.configElement.set(result.toArray());
        return requiresRestart;
    }

    public class ItemWrapperElement
    extends DummyConfigElement<Boolean>
    implements IConfigElement<Boolean> {
        public T item;

        public ItemWrapperElement(T item, boolean defaultValue, boolean currentValue) {
            super(SelectListConfigEntry.this.getItemName(item), (Object)defaultValue, ConfigGuiType.BOOLEAN, SelectListConfigEntry.this.getItemName(item));
            this.set(currentValue);
            this.item = item;
        }

        public String getComment() {
            return I18n.func_135052_a((String)SelectListConfigEntry.this.getTooltipLangKey(SelectListConfigEntry.this.configElement.getQualifiedName()), (Object[])new Object[]{EnumChatFormatting.GOLD + SelectListConfigEntry.this.getItemName(this.item) + EnumChatFormatting.YELLOW});
        }

        public Boolean getCurrentValue() {
            return (Boolean)this.value;
        }

        public void set(Boolean value) {
            this.value = value;
        }

        public void setDefault(Boolean value) {
            this.defaultValue = value;
        }
    }
}

