/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.Random;
import mods.betterfoliage.common.config.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;

public class WindTracker {
    public Random random = new Random();
    public double targetX;
    public double targetZ;
    public double currentX;
    public double currentZ;
    public long nextChange = 0L;

    public void changeWind(World world) {
        long changeTime = 120L;
        this.nextChange = world.func_72912_H().func_76073_f() + changeTime;
        double direction = Math.PI * 2 * this.random.nextDouble();
        double speed = Math.abs(this.random.nextGaussian()) * Config.leafFXWindStrength;
        if (world.func_72896_J()) {
            speed += Math.abs(this.random.nextGaussian()) * Config.leafFXStormStrength;
        }
        this.targetX = Math.cos(direction) * speed;
        this.targetZ = Math.sin(direction) * speed;
    }

    @SubscribeEvent
    public void handleWorldTick(TickEvent.ClientTickEvent event) {
        double deltaZ;
        double changeRate;
        double deltaX;
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        if (world.func_72912_H().func_76073_f() >= this.nextChange) {
            this.changeWind((World)world);
        }
        if ((deltaX = this.targetX - this.currentX) < -(changeRate = world.func_72896_J() ? 0.015 : 0.005)) {
            deltaX = -changeRate;
        }
        if (deltaX > changeRate) {
            deltaX = changeRate;
        }
        if ((deltaZ = this.targetZ - this.currentZ) < -changeRate) {
            deltaZ = -changeRate;
        }
        if (deltaZ > changeRate) {
            deltaZ = changeRate;
        }
        this.currentX += deltaX;
        this.currentZ += deltaZ;
    }

    @SubscribeEvent
    public void handleWorldLoad(WorldEvent.Load event) {
        if (event.world.field_72995_K) {
            this.changeWind(event.world);
        }
    }
}

