/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import mods.betterfoliage.common.config.Config;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class ShadersModIntegration {
    private static boolean hasShadersMod = false;
    private static int tallGrassEntityData;
    private static int leavesEntityData;
    private static Field shadersEntityData;
    private static Field shadersEntityDataIndex;

    private ShadersModIntegration() {
    }

    public static void init() {
        tallGrassEntityData = Block.field_149771_c.func_148757_b((Object)Blocks.field_150329_H) & 0xFFFF | Blocks.field_150329_H.func_149645_b() << 16;
        leavesEntityData = Block.field_149771_c.func_148757_b((Object)Blocks.field_150362_t) & 0xFFFF | Blocks.field_150362_t.func_149645_b() << 16;
        try {
            Class<?> classShaders = Class.forName("shadersmodcore.client.Shaders");
            shadersEntityData = classShaders.getDeclaredField("entityData");
            shadersEntityDataIndex = classShaders.getDeclaredField("entityDataIndex");
            hasShadersMod = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void startGrassQuads() {
        if (!hasShadersMod) {
            return;
        }
        ShadersModIntegration.setShadersEntityData(tallGrassEntityData);
    }

    public static void startLeavesQuads() {
        if (!hasShadersMod) {
            return;
        }
        ShadersModIntegration.setShadersEntityData(leavesEntityData);
    }

    private static void setShadersEntityData(int data) {
        try {
            int[] entityData = (int[])shadersEntityData.get(null);
            int entityDataIndex = shadersEntityDataIndex.getInt(null);
            entityData[entityDataIndex * 2] = data;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int getBlockIdOverride(int original, Block block) {
        if (Config.leaves.matchesID(original & 0xFFFF)) {
            return leavesEntityData;
        }
        if (Config.crops.matchesID(original & 0xFFFF)) {
            return tallGrassEntityData;
        }
        return original;
    }

    public static boolean isSpecialTexture(ResourceLocation resource) {
        return resource.func_110623_a().toLowerCase().endsWith("_n.png") || resource.func_110623_a().toLowerCase().endsWith("_s.png");
    }
}

