/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client;

import com.google.common.base.Charsets;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Set;
import mods.betterfoliage.BetterFoliage;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.world.WorldEvent;

public class BlockMatcher {
    public Set<Class<?>> whiteList = Sets.newHashSet();
    public Set<Class<?>> blackList = Sets.newHashSet();
    public Set<Integer> blockIDs = Sets.newHashSet();

    public boolean matchesClass(Block block) {
        for (Class<?> clazz : this.blackList) {
            if (!clazz.isAssignableFrom(block.getClass())) continue;
            return false;
        }
        for (Class<?> clazz : this.whiteList) {
            if (!clazz.isAssignableFrom(block.getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean matchesID(int blockId) {
        return this.blockIDs.contains(blockId);
    }

    public boolean matchesID(Block block) {
        return this.blockIDs.contains(Block.field_149771_c.func_148757_b((Object)block));
    }

    public void updateClassLists(String[] newWhitelist, String[] newBlacklist) {
        this.whiteList.clear();
        for (String className : newWhitelist) {
            try {
                this.whiteList.add(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        this.blackList.clear();
        for (String className : newBlacklist) {
            try {
                this.blackList.add(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        this.updateBlockIDs();
    }

    public void updateBlockIDs() {
        this.blockIDs.clear();
        for (Block block : Block.field_149771_c) {
            if (!this.matchesClass(block)) continue;
            this.blockIDs.add(Block.field_149771_c.func_148757_b((Object)block));
        }
    }

    public static void loadDefaultLists(ResourceLocation defaults, Collection<String> blacklist, Collection<String> whitelist) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(Minecraft.func_71410_x().func_110442_L().func_110536_a(defaults).func_110527_b(), Charsets.UTF_8));
            String line = reader.readLine();
            while (line != null) {
                if (!(line = line.trim()).isEmpty() && !line.startsWith("//")) {
                    if (line.startsWith("-")) {
                        blacklist.add(line.substring(1));
                    } else {
                        whitelist.add(line);
                    }
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (Exception e) {
            BetterFoliage.log.warn(String.format("Error reading configuration %s", defaults.toString()));
        }
    }

    @SubscribeEvent
    public void handleWorldLoad(WorldEvent.Load event) {
        if (event.world instanceof WorldClient) {
            this.updateBlockIDs();
        }
    }
}

