/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client;

import com.google.common.collect.Maps;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.Map;
import mods.betterfoliage.BetterFoliage;
import mods.betterfoliage.client.KeyHandler;
import mods.betterfoliage.client.ShadersModIntegration;
import mods.betterfoliage.client.WindTracker;
import mods.betterfoliage.client.render.IRenderBlockDecorator;
import mods.betterfoliage.client.render.impl.EntityFXFallingLeaves;
import mods.betterfoliage.client.render.impl.RenderBlockBetterAlgae;
import mods.betterfoliage.client.render.impl.RenderBlockBetterCactus;
import mods.betterfoliage.client.render.impl.RenderBlockBetterCoral;
import mods.betterfoliage.client.render.impl.RenderBlockBetterGrass;
import mods.betterfoliage.client.render.impl.RenderBlockBetterLeaves;
import mods.betterfoliage.client.render.impl.RenderBlockBetterLilypad;
import mods.betterfoliage.client.render.impl.RenderBlockBetterMycelium;
import mods.betterfoliage.client.render.impl.RenderBlockBetterReed;
import mods.betterfoliage.client.render.impl.RenderBlocksBetterGrassSide;
import mods.betterfoliage.client.resource.LeafGenerator;
import mods.betterfoliage.client.resource.LeafParticleTextures;
import mods.betterfoliage.client.resource.LeafTextureEnumerator;
import mods.betterfoliage.client.resource.ReedGenerator;
import mods.betterfoliage.client.resource.ShortGrassGenerator;
import mods.betterfoliage.common.config.Config;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class BetterFoliageClient {
    public static ResourceLocation missingTexture = new ResourceLocation("betterfoliage", "textures/blocks/missing_leaf.png");
    public static Map<Integer, IRenderBlockDecorator> decorators = Maps.newHashMap();
    public static LeafGenerator leafGenerator = new LeafGenerator();
    public static LeafParticleTextures leafParticles = new LeafParticleTextures(0);
    public static WindTracker wind = new WindTracker();

    public static void postInit() {
        FMLCommonHandler.instance().bus().register((Object)new KeyHandler());
        FMLCommonHandler.instance().bus().register((Object)new Config());
        BetterFoliage.log.info("Registering renderers");
        BetterFoliageClient.registerRenderer(new RenderBlockBetterCactus());
        BetterFoliageClient.registerRenderer(new RenderBlockBetterLilypad());
        BetterFoliageClient.registerRenderer(new RenderBlockBetterMycelium());
        BetterFoliageClient.registerRenderer(new RenderBlockBetterLeaves());
        BetterFoliageClient.registerRenderer(new RenderBlockBetterGrass());
        BetterFoliageClient.registerRenderer(new RenderBlockBetterReed());
        BetterFoliageClient.registerRenderer(new RenderBlockBetterAlgae());
        BetterFoliageClient.registerRenderer(new RenderBlockBetterCoral());
        BetterFoliageClient.registerRenderer(new RenderBlocksBetterGrassSide());
        MinecraftForge.EVENT_BUS.register((Object)wind);
        FMLCommonHandler.instance().bus().register((Object)wind);
        MinecraftForge.EVENT_BUS.register((Object)Config.leaves);
        MinecraftForge.EVENT_BUS.register((Object)Config.crops);
        MinecraftForge.EVENT_BUS.register((Object)Config.dirt);
        MinecraftForge.EVENT_BUS.register((Object)Config.grass);
        BetterFoliage.log.info("Registering texture generators");
        MinecraftForge.EVENT_BUS.register((Object)leafGenerator);
        MinecraftForge.EVENT_BUS.register((Object)leafParticles);
        MinecraftForge.EVENT_BUS.register((Object)new LeafTextureEnumerator());
        MinecraftForge.EVENT_BUS.register((Object)new ReedGenerator("bf_reed_bottom", missingTexture, true));
        MinecraftForge.EVENT_BUS.register((Object)new ReedGenerator("bf_reed_top", missingTexture, false));
        MinecraftForge.EVENT_BUS.register((Object)new ShortGrassGenerator("bf_shortgrass", missingTexture, false));
        MinecraftForge.EVENT_BUS.register((Object)new ShortGrassGenerator("bf_shortgrass_snow", missingTexture, true));
        ShadersModIntegration.init();
    }

    public static boolean isLeafTexture(TextureAtlasSprite icon) {
        String resourceLocation = icon.func_94215_i();
        return resourceLocation.startsWith("forestry:leaves/");
    }

    public static int getRenderTypeOverride(IBlockAccess blockAccess, int x, int y, int z, Block block, int original) {
        if (original == -1) {
            return original;
        }
        for (Map.Entry<Integer, IRenderBlockDecorator> entry : decorators.entrySet()) {
            if (!entry.getValue().isBlockAccepted(blockAccess, x, y, z, block, original)) continue;
            return entry.getKey();
        }
        return original;
    }

    public static void onRandomDisplayTick(Block block, World world, int x, int y, int z) {
        if (!Config.leafFXEnabled) {
            return;
        }
        if (!Config.leaves.matchesID(block) || !world.func_147437_c(x, y - 1, z)) {
            return;
        }
        if (Math.random() > Config.leafFXChance) {
            return;
        }
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntityFXFallingLeaves(world, x, y, z));
    }

    public static void registerRenderer(IRenderBlockDecorator decorator) {
        int renderId = RenderingRegistry.getNextAvailableRenderId();
        decorators.put(renderId, decorator);
        RenderingRegistry.registerBlockHandler((int)renderId, (ISimpleBlockRenderingHandler)decorator);
        MinecraftForge.EVENT_BUS.register((Object)decorator);
        decorator.init();
    }
}

