/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.resource;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import mods.betterfoliage.client.resource.BlockTextureGenerator;
import mods.betterfoliage.client.resource.BufferedImageResource;
import mods.betterfoliage.client.resource.LeafTextureEnumerator;
import mods.betterfoliage.common.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;

@SideOnly(value=Side.CLIENT)
public abstract class LeafGeneratorBase
extends BlockTextureGenerator {
    public String handDrawnLocationFormat;
    public String maskImageLocationFormat;
    public String nonGeneratedDomain;
    public int generatedCounter = 0;
    public int drawnCounter = 0;

    public LeafGeneratorBase(String domain, String nonGeneratedDomain, String handDrawnLocationFormat, String maskImageLocationFormat, ResourceLocation missingResource) {
        super(domain, missingResource);
        this.nonGeneratedDomain = nonGeneratedDomain;
        this.handDrawnLocationFormat = handDrawnLocationFormat;
        this.maskImageLocationFormat = maskImageLocationFormat;
    }

    public IResource func_110536_a(ResourceLocation resourceLocation) throws IOException {
        BufferedImage result;
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        ResourceLocation originalNoDirs = this.unwrapResource(resourceLocation);
        ResourceLocation originalWithDirs = new ResourceLocation(originalNoDirs.func_110624_b(), "textures/blocks/" + originalNoDirs.func_110623_a());
        ResourceLocation handDrawnLocation = new ResourceLocation(this.nonGeneratedDomain, String.format(this.handDrawnLocationFormat, originalNoDirs.func_110624_b(), originalNoDirs.func_110623_a()));
        if (Utils.resourceExists(handDrawnLocation)) {
            ++this.drawnCounter;
            return resourceManager.func_110536_a(handDrawnLocation);
        }
        if (!Utils.resourceExists(originalWithDirs)) {
            return this.getMissingResource();
        }
        try {
            result = this.generateLeaf(originalWithDirs);
        }
        catch (TextureGenerationException e) {
            return this.getMissingResource();
        }
        ++this.generatedCounter;
        return new BufferedImageResource(result);
    }

    protected abstract BufferedImage generateLeaf(ResourceLocation var1) throws IOException, TextureGenerationException;

    protected BufferedImage loadLeafMaskImage(String type, int size) {
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        IResource maskResource = null;
        while (maskResource == null && size >= 1) {
            try {
                maskResource = resourceManager.func_110536_a(new ResourceLocation(String.format(this.maskImageLocationFormat, size, type)));
            }
            catch (Exception e) {
                // empty catch block
            }
            size /= 2;
        }
        try {
            return maskResource == null ? null : ImageIO.read(maskResource.func_110527_b());
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    @SubscribeEvent
    public void handleTextureReload(TextureStitchEvent.Pre event) {
        super.handleTextureReload(event);
        if (event.map.func_130086_a() != 0) {
            return;
        }
        this.generatedCounter = 0;
        this.drawnCounter = 0;
    }

    @SubscribeEvent
    public void handleRegisterTexture(LeafTextureEnumerator.LeafTextureFoundEvent event) {
        event.blockTextures.func_94245_a(new ResourceLocation(this.domainName, event.icon.func_94215_i()).toString());
    }

    @SideOnly(value=Side.CLIENT)
    public static class TextureGenerationException
    extends Exception {
        private static final long serialVersionUID = 7339757761980002651L;
    }
}

