/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.resource;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import mods.betterfoliage.BetterFoliage;
import mods.betterfoliage.client.BetterFoliageClient;
import mods.betterfoliage.client.ShadersModIntegration;
import mods.betterfoliage.client.resource.LeafGeneratorBase;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;

@SideOnly(value=Side.CLIENT)
public class LeafGenerator
extends LeafGeneratorBase {
    public static String defaultMask = "default";

    public LeafGenerator() {
        super("bf_leaves", "betterfoliage", "textures/blocks/%s/%s", "betterfoliage:textures/blocks/leafmask_%d_%s.png", BetterFoliageClient.missingTexture);
    }

    @Override
    protected BufferedImage generateLeaf(ResourceLocation originalWithDirs) throws IOException, LeafGeneratorBase.TextureGenerationException {
        BufferedImage origImage = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(originalWithDirs).func_110527_b());
        if (origImage.getWidth() != origImage.getHeight()) {
            throw new LeafGeneratorBase.TextureGenerationException();
        }
        int size = origImage.getWidth();
        BufferedImage overlayIcon = new BufferedImage(size * 2, size * 2, 6);
        Graphics2D graphics = overlayIcon.createGraphics();
        graphics.drawImage((Image)origImage, 0, 0, null);
        graphics.drawImage((Image)origImage, 0, size, null);
        graphics.drawImage((Image)origImage, size, 0, null);
        graphics.drawImage((Image)origImage, size, size, null);
        if (!ShadersModIntegration.isSpecialTexture(originalWithDirs)) {
            BufferedImage maskImage = this.loadLeafMaskImage(defaultMask, size * 2);
            int scale = size * 2 / maskImage.getWidth();
            for (int x = 0; x < overlayIcon.getWidth(); ++x) {
                for (int y = 0; y < overlayIcon.getHeight(); ++y) {
                    long origPixel = (long)overlayIcon.getRGB(x, y) & 0xFFFFFFFFL;
                    long maskPixel = (long)maskImage.getRGB(x / scale, y / scale) & 0xFF000000L | 0xFFFFFFL;
                    overlayIcon.setRGB(x, y, (int)(origPixel & maskPixel));
                }
            }
        }
        return overlayIcon;
    }

    @Override
    @SubscribeEvent
    public void endTextureReload(TextureStitchEvent.Post event) {
        super.endTextureReload(event);
        if (event.map.func_130086_a() != 0) {
            return;
        }
        BetterFoliage.log.info(String.format("Found %d pre-drawn leaf textures", this.drawnCounter));
        BetterFoliage.log.info(String.format("Generated %d leaf textures", this.generatedCounter));
    }
}

