/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.render.impl;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mods.betterfoliage.BetterFoliage;
import mods.betterfoliage.client.ShadersModIntegration;
import mods.betterfoliage.client.render.IRenderBlockDecorator;
import mods.betterfoliage.client.render.IconSet;
import mods.betterfoliage.client.render.RenderBlockAOBase;
import mods.betterfoliage.common.config.Config;
import mods.betterfoliage.common.util.Double3;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.gen.NoiseGeneratorSimplex;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.WorldEvent;

@SideOnly(value=Side.CLIENT)
public class RenderBlockBetterReed
extends RenderBlockAOBase
implements IRenderBlockDecorator {
    public IconSet reedBottomIcons = new IconSet("bf_reed_bottom", "bettergrassandleaves:better_reed_%d");
    public IconSet reedTopIcons = new IconSet("bf_reed_top", "bettergrassandleaves:better_reed_%d");
    public NoiseGeneratorSimplex noise;

    @Override
    public boolean isBlockAccepted(IBlockAccess blockAccess, int x, int y, int z, Block block, int original) {
        if (!Config.reedEnabled) {
            return false;
        }
        if (!Config.dirt.matchesID(block)) {
            return false;
        }
        if (!Config.reedBiomeList.contains(blockAccess.func_72807_a((int)x, (int)z).field_76756_M)) {
            return false;
        }
        if (blockAccess.func_147439_a(x, y + 1, z).func_149688_o() != Material.field_151586_h) {
            return false;
        }
        if (!blockAccess.func_147437_c(x, y + 2, z)) {
            return false;
        }
        int terrainVariation = MathHelper.func_76128_c((double)((this.noise.func_151605_a((double)x, (double)z) + 1.0) * 32.0));
        return terrainVariation < Config.reedPopulation;
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        this.field_147845_a = world;
        this.renderWorldBlockBase(1, world, x, y, z, block, modelId, renderer);
        int iconVariation = this.getSemiRandomFromPos(x, y, z, 0);
        int heightVariation = this.getSemiRandomFromPos(x, y, z, 1);
        IIcon bottomIcon = this.reedBottomIcons.get(iconVariation);
        IIcon topIcon = this.reedTopIcons.get(iconVariation);
        if (bottomIcon == null || topIcon == null) {
            return true;
        }
        double quarterHeight = 0.25 * (Config.reedHeightMin + this.pRand[heightVariation] * (Config.reedHeightMax - Config.reedHeightMin));
        Tessellator.field_78398_a.func_78380_c(this.getBrightness(block, x, y + 2, z));
        Tessellator.field_78398_a.func_78376_a(255, 255, 255);
        ShadersModIntegration.startGrassQuads();
        this.renderCrossedSideQuads(new Double3((double)x + 0.5, (double)y + 1.0, (double)z + 0.5), ForgeDirection.UP, 0.5, quarterHeight, this.pRot[iconVariation], Config.reedHOffset, bottomIcon, 0, true);
        this.renderCrossedSideQuads(new Double3((double)x + 0.5, (double)y + 1.0 + 2.0 * quarterHeight, (double)z + 0.5), ForgeDirection.UP, 0.5, quarterHeight, this.pRot[iconVariation], Config.reedHOffset, topIcon, 0, true);
        return true;
    }

    @SubscribeEvent
    public void handleTextureReload(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() != 0) {
            return;
        }
        this.reedBottomIcons.registerIcons((IIconRegister)event.map);
        this.reedTopIcons.registerIcons((IIconRegister)event.map);
        BetterFoliage.log.info(String.format("Found %d reed textures", this.reedBottomIcons.numLoaded));
    }

    @SubscribeEvent
    public void handleWorldLoad(WorldEvent.Load event) {
        this.noise = new NoiseGeneratorSimplex(new Random(event.world.func_72912_H().func_76063_b()));
    }
}

