/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.render.impl;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.betterfoliage.BetterFoliage;
import mods.betterfoliage.client.ShadersModIntegration;
import mods.betterfoliage.client.render.IRenderBlockDecorator;
import mods.betterfoliage.client.render.IconSet;
import mods.betterfoliage.client.render.RenderBlockAOBase;
import mods.betterfoliage.common.config.Config;
import mods.betterfoliage.common.util.Double3;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.util.ForgeDirection;

@SideOnly(value=Side.CLIENT)
public class RenderBlockBetterMycelium
extends RenderBlockAOBase
implements IRenderBlockDecorator {
    public IconSet myceliumIcons = new IconSet("bettergrassandleaves", "better_mycel_%d");

    @Override
    public boolean isBlockAccepted(IBlockAccess blockAccess, int x, int y, int z, Block block, int original) {
        if (!Config.grassEnabled) {
            return false;
        }
        if (block != Blocks.field_150391_bh) {
            return false;
        }
        return blockAccess.func_147437_c(x, y + 1, z) || blockAccess.func_147439_a(x, y + 1, z) == Blocks.field_150431_aC;
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        this.field_147845_a = world;
        this.renderWorldBlockBase(1, world, x, y, z, block, modelId, renderer);
        boolean isSnowed = this.field_147845_a.func_147439_a(x, y + 1, z) == Blocks.field_150431_aC;
        int iconVariation = this.getSemiRandomFromPos(x, y, z, 0);
        IIcon renderIcon = this.myceliumIcons.get(iconVariation);
        if (isSnowed || renderIcon == null) {
            return true;
        }
        int heightVariation = this.getSemiRandomFromPos(x, y, z, 1);
        double scale = Config.grassSize * 0.5;
        double halfHeight = 0.5 * (Config.grassHeightMin + this.pRand[heightVariation] * (Config.grassHeightMax - Config.grassHeightMin));
        if (isSnowed) {
            this.aoYPXZNN.setGray(0.9f);
            this.aoYPXZNP.setGray(0.9f);
            this.aoYPXZPN.setGray(0.9f);
            this.aoYPXZPP.setGray(0.9f);
            Tessellator.field_78398_a.func_78376_a(230, 230, 230);
        }
        ShadersModIntegration.startGrassQuads();
        Tessellator.field_78398_a.func_78380_c(this.getBrightness(block, x, y + 1, z));
        Tessellator.field_78398_a.func_78378_d(block.func_149720_d(this.field_147845_a, x, y, z));
        this.renderCrossedSideQuads(new Double3((double)x + 0.5, (double)y + 1.0 + (isSnowed ? 0.0625 : 0.0), (double)z + 0.5), ForgeDirection.UP, scale, halfHeight, this.pRot[iconVariation], Config.grassHOffset, renderIcon, 0, false);
        return true;
    }

    @SubscribeEvent
    public void handleTextureReload(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() != 0) {
            return;
        }
        this.myceliumIcons.registerIcons((IIconRegister)event.map);
        BetterFoliage.log.info(String.format("Found %d mycelium textures", this.myceliumIcons.numLoaded));
    }
}

