/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.render.impl;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.betterfoliage.BetterFoliage;
import mods.betterfoliage.client.BetterFoliageClient;
import mods.betterfoliage.client.render.IRenderBlockDecorator;
import mods.betterfoliage.client.render.RenderBlockAOBase;
import mods.betterfoliage.common.config.Config;
import mods.betterfoliage.common.util.Double3;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

@SideOnly(value=Side.CLIENT)
public class RenderBlockBetterLeaves
extends RenderBlockAOBase
implements IRenderBlockDecorator {
    @Override
    public boolean isBlockAccepted(IBlockAccess blockAccess, int x, int y, int z, Block block, int original) {
        if (!Config.leavesEnabled) {
            return false;
        }
        if (original > 0 && original < 42) {
            return false;
        }
        return Config.leaves.matchesID(block) && !this.isBlockSurrounded(blockAccess, x, y, z);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        boolean isAirBottom;
        this.field_147845_a = world;
        this.renderWorldBlockBase(1, world, x, y, z, block, modelId, renderer);
        TextureAtlasSprite blockLeafIcon = null;
        try {
            blockLeafIcon = (TextureAtlasSprite)block.func_149673_e(world, x, y, z, ForgeDirection.NORTH.ordinal());
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        if (blockLeafIcon == null) {
            BetterFoliage.log.debug(String.format("null leaf texture, x:%d, y:%d, z:%d, meta:%d, block:%s", x, y, z, this.field_147845_a.func_72805_g(x, y, z), block.getClass().getName()));
            return true;
        }
        TextureAtlasSprite crossLeafIcon = Minecraft.func_71410_x().func_147117_R().func_110572_b(BetterFoliageClient.leafGenerator.domainName + ":" + blockLeafIcon.func_94215_i());
        if (crossLeafIcon == null) {
            return true;
        }
        int offsetVariation = this.getSemiRandomFromPos(x, y, z, 0);
        int uvVariation = this.getSemiRandomFromPos(x, y, z, 1);
        double halfSize = 0.5 * Config.leavesSize;
        boolean isAirTop = y == 255 || this.field_147845_a.func_147437_c(x, y + 1, z);
        boolean bl = isAirBottom = y == 0 || this.field_147845_a.func_147437_c(x, y - 1, z);
        Tessellator.field_78398_a.func_78380_c(isAirTop ? this.getBrightness(block, x, y + 1, z) : (isAirBottom ? this.getBrightness(block, x, y - 1, z) : this.getBrightness(block, x, y, z)));
        Tessellator.field_78398_a.func_78378_d(block.func_149720_d(this.field_147845_a, x, y, z));
        if (Config.leavesSkew) {
            this.renderCrossedBlockQuadsSkew(new Double3((double)x + 0.5, (double)y + 0.5, (double)z + 0.5), halfSize, this.pRot[offsetVariation].scaleAxes(Config.leavesHOffset, Config.leavesVOffset, Config.leavesHOffset), this.pRot[offsetVariation + 1 & 0x3F].scaleAxes(Config.leavesHOffset, Config.leavesVOffset, Config.leavesHOffset), (IIcon)crossLeafIcon, uvVariation, isAirTop, isAirBottom);
        } else {
            this.renderCrossedBlockQuadsTranslate(new Double3((double)x + 0.5, (double)y + 0.5, (double)z + 0.5), halfSize, this.pRot[offsetVariation].scaleAxes(Config.leavesHOffset, Config.leavesVOffset, Config.leavesHOffset), (IIcon)crossLeafIcon, uvVariation, isAirTop, isAirBottom);
        }
        return true;
    }

    protected boolean isBlockSurrounded(IBlockAccess blockAccess, int x, int y, int z) {
        if (this.isBlockNonSurrounding(blockAccess.func_147439_a(x + 1, y, z))) {
            return false;
        }
        if (this.isBlockNonSurrounding(blockAccess.func_147439_a(x - 1, y, z))) {
            return false;
        }
        if (this.isBlockNonSurrounding(blockAccess.func_147439_a(x, y + 1, z))) {
            return false;
        }
        if (this.isBlockNonSurrounding(blockAccess.func_147439_a(x, y - 1, z))) {
            return false;
        }
        if (this.isBlockNonSurrounding(blockAccess.func_147439_a(x, y, z + 1))) {
            return false;
        }
        return !this.isBlockNonSurrounding(blockAccess.func_147439_a(x, y, z - 1));
    }

    protected boolean isBlockNonSurrounding(Block block) {
        return block.func_149688_o() == Material.field_151579_a || block == Blocks.field_150431_aC;
    }
}

