/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.render.impl;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Random;
import mods.betterfoliage.BetterFoliage;
import mods.betterfoliage.client.render.IRenderBlockDecorator;
import mods.betterfoliage.client.render.IconSet;
import mods.betterfoliage.client.render.RenderBlockAOBase;
import mods.betterfoliage.common.config.Config;
import mods.betterfoliage.common.util.Double3;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.gen.NoiseGeneratorSimplex;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.WorldEvent;

public class RenderBlockBetterCoral
extends RenderBlockAOBase
implements IRenderBlockDecorator {
    public IconSet coralCrustIcons = new IconSet("bettergrassandleaves", "better_crust_%d");
    public IconSet coralCrossIcons = new IconSet("bettergrassandleaves", "better_coral_%d");
    public NoiseGeneratorSimplex noise;

    @Override
    public boolean isBlockAccepted(IBlockAccess blockAccess, int x, int y, int z, Block block, int original) {
        if (!Config.coralEnabled) {
            return false;
        }
        if (block != Blocks.field_150354_m) {
            return false;
        }
        if (!Config.coralBiomeList.contains(blockAccess.func_72807_a((int)x, (int)z).field_76756_M)) {
            return false;
        }
        int terrainVariation = MathHelper.func_76128_c((double)((this.noise.func_151605_a((double)x * 0.1, (double)z * 0.1) + 1.0) * 32.0));
        return terrainVariation < Config.coralPopulation;
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        this.field_147845_a = world;
        this.renderWorldBlockBase(1, world, x, y, z, block, modelId, renderer);
        Double3 blockCenter = new Double3((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        double offset = this.pRand[this.getSemiRandomFromPos(x, y, z, 6)] * Config.coralVOffset;
        double halfSize = Config.coralSize * 0.5;
        double halfCrustSize = Config.coralCrustSize * 0.5;
        Tessellator.field_78398_a.func_78380_c(this.getBrightness(block, x, y, z));
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int variation;
            if (this.field_147845_a.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ).func_149688_o() != Material.field_151586_h || this.field_147845_a.func_147437_c(x + dir.offsetX, y + dir.offsetY + 1, z + dir.offsetZ) || (variation = this.getSemiRandomFromPos(x, y, z, dir.ordinal())) >= Config.coralChance) continue;
            IIcon crustIcon = this.coralCrustIcons.get(variation);
            IIcon coralIcon = this.coralCrossIcons.get(variation);
            if (crustIcon != null) {
                this.renderCoralCrust(blockCenter, dir, offset, halfCrustSize, crustIcon, variation);
            }
            if (coralIcon == null) continue;
            this.renderCrossedSideQuads(blockCenter.add(new Double3(dir).scale(0.5)), dir, halfSize, halfSize, this.pRot[variation], Config.coralHOffset, coralIcon, 0, false);
        }
        return true;
    }

    protected void renderCoralCrust(Double3 blockCenter, ForgeDirection dir, double offset, double scale, IIcon icon, int uvRot) {
        Double3 face1 = new Double3(this.faceDir1[dir.ordinal()]).scale(scale);
        Double3 face2 = new Double3(this.faceDir2[dir.ordinal()]).scale(scale);
        Double3 drawCenter = blockCenter.add(new Double3(dir).scale(0.5 + offset));
        if (Minecraft.func_71379_u()) {
            this.setShadingForFace(dir);
            this.renderQuadWithShading(icon, drawCenter, face1, face2, uvRot, this.faceAOPP, this.faceAONP, this.faceAONN, this.faceAOPN);
        } else {
            this.renderQuad(icon, drawCenter, face1, face2, uvRot);
        }
    }

    @SubscribeEvent
    public void handleTextureReload(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() != 0) {
            return;
        }
        this.coralCrustIcons.registerIcons((IIconRegister)event.map);
        this.coralCrossIcons.registerIcons((IIconRegister)event.map);
        BetterFoliage.log.info(String.format("Found %d coral crust textures", this.coralCrustIcons.numLoaded));
        BetterFoliage.log.info(String.format("Found %d coral textures", this.coralCrossIcons.numLoaded));
    }

    @SubscribeEvent
    public void handleWorldLoad(WorldEvent.Load event) {
        this.noise = new NoiseGeneratorSimplex(new Random(event.world.func_72912_H().func_76063_b() + 2L));
    }
}

