/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.render.impl;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mods.betterfoliage.BetterFoliage;
import mods.betterfoliage.client.render.IRenderBlockDecorator;
import mods.betterfoliage.client.render.IconSet;
import mods.betterfoliage.client.render.RenderBlockAOBase;
import mods.betterfoliage.common.config.Config;
import mods.betterfoliage.common.util.Double3;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.gen.NoiseGeneratorSimplex;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.WorldEvent;

@SideOnly(value=Side.CLIENT)
public class RenderBlockBetterAlgae
extends RenderBlockAOBase
implements IRenderBlockDecorator {
    public IconSet algaeIcons = new IconSet("bettergrassandleaves", "better_algae_%d");
    public NoiseGeneratorSimplex noise;

    @Override
    public boolean isBlockAccepted(IBlockAccess blockAccess, int x, int y, int z, Block block, int original) {
        if (!Config.algaeEnabled) {
            return false;
        }
        if (!Config.dirt.matchesID(block)) {
            return false;
        }
        if (!Config.algaeBiomeList.contains(blockAccess.func_72807_a((int)x, (int)z).field_76756_M)) {
            return false;
        }
        if (blockAccess.func_147439_a(x, y + 1, z).func_149688_o() != Material.field_151586_h) {
            return false;
        }
        if (blockAccess.func_147439_a(x, y + 2, z).func_149688_o() != Material.field_151586_h) {
            return false;
        }
        int terrainVariation = MathHelper.func_76128_c((double)((this.noise.func_151605_a((double)x, (double)z) + 1.0) * 32.0));
        return terrainVariation < Config.algaePopulation;
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        this.field_147845_a = world;
        if (renderer.func_147744_b()) {
            renderer.func_147775_a(block);
            renderer.func_147784_q(block, x, y, z);
            return true;
        }
        this.setPassCounters(1);
        this.func_147775_a(block);
        this.func_147784_q(block, x, y, z);
        int variation = this.getSemiRandomFromPos(x, y, z, 0);
        int heightVariation = this.getSemiRandomFromPos(x, y, z, 1);
        IIcon renderIcon = this.algaeIcons.get(variation);
        if (renderIcon == null) {
            return true;
        }
        double scale = Config.algaeSize * 0.5;
        double halfHeight = 0.5 * (Config.algaeHeightMin + this.pRand[heightVariation] * (Config.algaeHeightMax - Config.algaeHeightMin));
        Tessellator.field_78398_a.func_78380_c(this.getBrightness(block, x, y + 1, z));
        this.renderCrossedSideQuads(new Double3((double)x + 0.5, (double)y + 1.0 - 0.125 * halfHeight, (double)z + 0.5), ForgeDirection.UP, scale, halfHeight, this.pRot[variation], Config.algaeHOffset, renderIcon, 0, false);
        return true;
    }

    @SubscribeEvent
    public void handleTextureReload(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() != 0) {
            return;
        }
        this.algaeIcons.registerIcons((IIconRegister)event.map);
        BetterFoliage.log.info(String.format("Found %d algae textures", this.algaeIcons.numLoaded));
    }

    @SubscribeEvent
    public void handleWorldLoad(WorldEvent.Load event) {
        this.noise = new NoiseGeneratorSimplex(new Random(event.world.func_72912_H().func_76063_b() + 1L));
    }
}

