/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.render.impl;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import mods.betterfoliage.client.BetterFoliageClient;
import mods.betterfoliage.common.config.Config;
import mods.betterfoliage.common.util.Double3;
import net.minecraft.block.Block;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@SideOnly(value=Side.CLIENT)
public class EntityFXFallingLeaves
extends EntityFX {
    protected static double[] cos = new double[64];
    protected static double[] sin = new double[64];
    public static float biomeBrightnessMultiplier;
    public boolean wasOnGround = false;
    public boolean isMirrored;
    public int particleRotation = 0;
    public boolean rotationPositive = true;

    public EntityFXFallingLeaves(World world, int x, int y, int z) {
        super(world, (double)x + 0.5, (double)y, (double)z + 0.5);
        this.field_70547_e = MathHelper.func_76128_c((double)((0.6 + 0.4 * this.field_70146_Z.nextDouble()) * Config.leafFXLifetime * 20.0));
        this.isMirrored = (this.field_70146_Z.nextInt() & 1) == 1;
        this.field_70181_x = -Config.leafFXSpeed;
        this.particleRotation = this.field_70146_Z.nextInt(64);
        this.field_70544_f = (float)Config.leafFXSize;
        this.field_70550_a = BetterFoliageClient.leafParticles.icons.get(this.field_70146_Z.nextInt(1024));
        Block block = world.func_147439_a(x, y, z);
        IIcon blockIcon = block.func_149673_e((IBlockAccess)world, x, y, z, ForgeDirection.DOWN.ordinal());
        this.calculateParticleColor(BetterFoliageClient.leafParticles.getColor(blockIcon), block.func_149720_d((IBlockAccess)world, x, y, z));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70544_f = (float)Config.leafFXSize;
        if (this.field_70146_Z.nextFloat() > 0.95f) {
            boolean bl = this.rotationPositive = !this.rotationPositive;
        }
        if (this.field_70546_d > this.field_70547_e - 20) {
            this.field_82339_as = 0.05f * (float)(this.field_70547_e - this.field_70546_d);
        }
        if (this.field_70122_E || this.wasOnGround) {
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
            this.field_70179_y = 0.0;
            if (!this.wasOnGround) {
                this.field_70546_d = Math.max(this.field_70546_d, this.field_70547_e - 20);
            }
            this.wasOnGround = true;
        } else {
            this.field_70159_w = (BetterFoliageClient.wind.currentX + cos[this.particleRotation] * Config.leafFXPerturb) * Config.leafFXSpeed;
            this.field_70179_y = (BetterFoliageClient.wind.currentZ + sin[this.particleRotation] * Config.leafFXPerturb) * Config.leafFXSpeed;
            this.field_70181_x = -Config.leafFXSpeed;
            this.particleRotation = this.particleRotation + (this.rotationPositive ? 1 : -1) & 0x3F;
        }
    }

    public void func_70539_a(Tessellator tessellator, float partialTickTime, float rotX, float rotZ, float rotYZ, float rotXY, float rotXZ) {
        float minU = this.isMirrored ? this.field_70550_a.func_94209_e() : this.field_70550_a.func_94212_f();
        float maxU = this.isMirrored ? this.field_70550_a.func_94212_f() : this.field_70550_a.func_94209_e();
        float minV = this.field_70550_a.func_94206_g();
        float maxV = this.field_70550_a.func_94210_h();
        float scale = 0.1f * this.field_70544_f;
        Double3 center = new Double3(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)partialTickTime - field_70556_an, this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)partialTickTime - field_70554_ao, this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)partialTickTime - field_70555_ap);
        Double3 vec1 = new Double3(rotX + rotXY, rotZ, rotYZ + rotXZ).scale(scale);
        Double3 vec2 = new Double3(rotX - rotXY, -rotZ, rotYZ - rotXZ).scale(scale);
        Double3 vec1Rot = vec1.scale(cos[this.particleRotation]).add(vec2.scale(sin[this.particleRotation]));
        Double3 vec2Rot = vec1.scale(-sin[this.particleRotation]).add(vec2.scale(cos[this.particleRotation]));
        tessellator.func_78369_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as);
        this.addVertex(tessellator, center.sub(vec1Rot), maxU, maxV);
        this.addVertex(tessellator, center.sub(vec2Rot), maxU, minV);
        this.addVertex(tessellator, center.add(vec1Rot), minU, minV);
        this.addVertex(tessellator, center.add(vec2Rot), minU, maxV);
    }

    protected void addVertex(Tessellator tessellator, Double3 coord, double u, double v) {
        tessellator.func_78374_a(coord.x, coord.y, coord.z, u, v);
    }

    public void calculateParticleColor(int textureAvgColor, int blockColor) {
        float[] hsbTexture = Color.RGBtoHSB(textureAvgColor >> 16 & 0xFF, textureAvgColor >> 8 & 0xFF, textureAvgColor & 0xFF, null);
        float[] hsbBlock = Color.RGBtoHSB(blockColor >> 16 & 0xFF, blockColor >> 8 & 0xFF, blockColor & 0xFF, null);
        float weightTex = hsbTexture[1] / (hsbTexture[1] + hsbBlock[1]);
        float weightBlock = 1.0f - weightTex;
        float h = weightTex * hsbTexture[0] + weightBlock * hsbBlock[0];
        float s = weightTex * hsbTexture[1] + weightBlock * hsbBlock[1];
        float b = weightTex * hsbTexture[2] + weightBlock * hsbBlock[2] * biomeBrightnessMultiplier;
        int particleColor = Color.HSBtoRGB(h, s, b);
        this.field_70551_j = (float)(particleColor & 0xFF) / 256.0f;
        this.field_70553_i = (float)(particleColor >> 8 & 0xFF) / 256.0f;
        this.field_70552_h = (float)(particleColor >> 16 & 0xFF) / 256.0f;
    }

    public int func_70537_b() {
        return 1;
    }

    static {
        for (int idx = 0; idx < 64; ++idx) {
            EntityFXFallingLeaves.cos[idx] = Math.cos(0.09817477042468103 * (double)idx);
            EntityFXFallingLeaves.sin[idx] = Math.sin(0.09817477042468103 * (double)idx);
        }
        biomeBrightnessMultiplier = 0.5f;
    }
}

