/*
 * Decompiled with CFR 0.152.
 */
package okushama.battlemusic.plugin;

import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import okushama.battlemusic.client.ProxyClient;
import okushama.battlemusic.core.BattleStream;
import okushama.battlemusic.plugin.IPlugin;
import okushama.battlemusic.plugin.PluginBase;

public class PVPTracker
extends PluginBase
implements IPlugin {
    private boolean triggerAllPlayers = false;
    private boolean triggerVanillaTeamPlayers = false;
    private boolean triggerTestPlayers = false;
    public Configuration config = null;
    private List<Entity> loadedEnemies;

    public PVPTracker() {
        this.enabled = true;
        this.breaksCoreLoop = true;
    }

    @Override
    public String pluginName() {
        return "PVP";
    }

    @Override
    public void onModInit(FMLPreInitializationEvent evt) {
        this.config = new Configuration(new File(evt.getSuggestedConfigurationFile().getParentFile(), "battlemusic-plugin-pvp.cfg"));
        this.loadConfig();
    }

    @Override
    public void loadConfig() {
        this.triggerAllPlayers = this.config.get("pvp", "Trigger music for all players", false).getBoolean(false);
        this.triggerVanillaTeamPlayers = this.config.get("pvp", "Trigger music for opposing Team players", false).getBoolean(false);
        this.triggerTestPlayers = this.config.get("pvp", "Trigger test", false).getBoolean(false);
        this.config.load();
        this.config.save();
    }

    @Override
    public void updateConfig() {
        this.loadConfig();
        this.config.get("pvp", "Trigger music for all players", this.triggerAllPlayers).set(this.triggerAllPlayers);
        this.config.get("pvp", "Trigger music for opposing Team players", this.triggerVanillaTeamPlayers).set(this.triggerVanillaTeamPlayers);
        this.config.get("pvp", "Trigger test", this.triggerTestPlayers).set(this.triggerTestPlayers);
        this.config.save();
    }

    @Override
    public void onClientTick(Minecraft mc, World w) {
        int i;
        List ents;
        this.loadedEnemies = new ArrayList<Entity>();
        if (this.triggerAllPlayers) {
            ents = w.field_72996_f;
            for (i = 0; i < ents.size(); ++i) {
                if (!(ents.get(i) instanceof EntityPlayer) || ents.get(i) == mc.field_71439_g) continue;
                this.loadedEnemies.add((Entity)ents.get(i));
            }
        }
        if (this.triggerVanillaTeamPlayers && mc.field_71439_g.func_96124_cp() != null) {
            ents = w.field_72996_f;
            for (i = 0; i < ents.size(); ++i) {
                if (!(ents.get(i) instanceof EntityPlayer) || ents.get(i) == mc.field_71439_g || ((EntityPlayer)ents.get(i)).func_96124_cp().func_142054_a(mc.field_71439_g.func_96124_cp())) continue;
                this.loadedEnemies.add((Entity)ents.get(i));
            }
        }
        BattleStream stream = ProxyClient.mainStream;
        if (this.loadedEnemies.size() > 0) {
            for (i = 0; i < this.loadedEnemies.size(); ++i) {
                Entity enemy = this.loadedEnemies.get(i);
                if (enemy.func_70068_e((Entity)mc.field_71439_g) < 200.0 && mc.field_71439_g.func_70685_l(enemy)) {
                    stream.volumeUp();
                    stream.play("overworld.ogg", true);
                    continue;
                }
                stream.fadeToStop();
            }
        } else {
            stream.fadeToStop();
        }
    }
}

