/*
 * Decompiled with CFR 0.152.
 */
package okushama.battlemusic.core;

import java.io.BufferedInputStream;
import java.io.InputStream;
import okushama.battlemusic.Helper;
import okushama.battlemusic.client.ProxyClient;
import okushama.okutils.sound.Music;
import okushama.okutils.sound.Stream;

public class BattleStream
extends Stream {
    public String lastTheme = "";
    public String currentPack = "";

    public BattleStream(String m, String s) {
        super(m, s);
        this.volume = -60.0f;
        this.loop = true;
    }

    public boolean stop(boolean b) {
        boolean r = super.stop(b);
        return r;
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    if (this.mainMusic.isFinished && this.loop) {
                        this.play(this.lastFile, false);
                    }
                    Thread.sleep(20L);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    public void fadeToStop() {
        if (this.mainMusic == null) {
            return;
        }
        if (!this.mainMusic.isFinished) {
            this.volumeDown();
            if (this.volume < -70.0f) {
                this.stop(false);
            }
        }
    }

    public void volume(float newVol) {
        if (this.mainMusic == null) {
            return;
        }
        float in = newVol;
        if (in > 0.0f) {
            in = 0.0f;
        }
        if (in < -70.0f) {
            in = -70.0f;
        }
        this.volume = in;
    }

    public void volumeUp() {
        if (this.mainMusic == null) {
            return;
        }
        float amt = 0.5f;
        if (this.volume < -50.0f) {
            amt = 0.75f;
        }
        this.volume = this.volume < ProxyClient.config.getMaxVolume() ? (this.volume += amt) : ProxyClient.config.getMaxVolume();
    }

    public void volumeDown() {
        if (this.mainMusic == null) {
            return;
        }
        if (this.volume > -79.0f) {
            this.volume -= 0.5f;
        } else {
            System.out.println("Stopped!");
            this.stop(true);
        }
    }

    public void play(String file, boolean setVol) {
        if (this.mainMusic == null || this.mainMusic.isFinished || file != this.lastTheme || !this.loop) {
            // empty if block
        }
        if (this.mainMusic != null && file != this.lastTheme) {
            this.stop(false);
            this.mainMusic = null;
        }
        if (this.mainMusic == null) {
            try {
                if (setVol) {
                    this.volume = -80.0f;
                }
                InputStream filein = null;
                try {
                    filein = Helper.getZipStream(Helper.getCurrentTheme(), file);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (filein == null) {
                    return;
                }
                BufferedInputStream in = new BufferedInputStream(filein);
                if (setVol) {
                    this.volume = ProxyClient.config.getMaxVolume();
                }
                this.mainMusic = new Music((InputStream)in, (Stream)this);
                this.lastTheme = file;
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            if (this.mainMusic.isFinished) {
                BufferedInputStream in = new BufferedInputStream(Helper.getZipStream(Helper.getCurrentTheme(), file));
                this.mainMusic = new Music((InputStream)in, (Stream)this);
                this.volume = ProxyClient.config.getMaxVolume();
                this.lastTheme = file;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

