/*
 * Decompiled with CFR 0.152.
 */
package okushama.battlemusic.client;

import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.ZipFile;
import net.minecraftforge.common.config.Configuration;
import okushama.battlemusic.Helper;
import okushama.battlemusic.ModMobData;
import okushama.battlemusic.Theme;
import okushama.battlemusic.ThemesGetMore;
import okushama.battlemusic.client.GuiBattleMusicNew;
import okushama.battlemusic.pop.Assets;

public class ConfigManager {
    private static String[] biomesList;
    private static String[] biomeThemes;
    private static String[] mobsToPlayTo;
    public static int currentPack;
    public boolean ignoreDragonDistance;
    public boolean showFightOverlay;
    public float maxVolume;
    public ArrayList<Theme> themes = new ArrayList();
    public Configuration config;
    private static HashMap<String, String> biomeThemeMap;

    public void injectInitialPacks() {
        InputStream stream = ConfigManager.class.getResourceAsStream("default.zip");
        if (stream == null) {
            return;
        }
        byte[] buffer = new byte[4096];
        try {
            int readBytes;
            FileOutputStream out = new FileOutputStream(new File(Helper.getMinecraftDir("battlemusic"), "default.zip"));
            while ((readBytes = stream.read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, readBytes);
            }
            ((OutputStream)out).close();
            System.out.println("Created default pack in .minecraft/battlemusic/!");
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void injectInitialModMobSupport() {
        InputStream stream = ConfigManager.class.getResourceAsStream("mod-mob-support.json");
        if (stream == null) {
            return;
        }
        byte[] buffer = new byte[4096];
        try {
            int readBytes;
            FileOutputStream out = new FileOutputStream(new File(Helper.getMinecraftDir("battlemusic"), "mod-mob-support.json"));
            while ((readBytes = stream.read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, readBytes);
            }
            ((OutputStream)out).close();
            System.out.println("Created mob support file in .minecraft/battlemusic/!");
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void loadThemes() {
        this.themes = new ArrayList();
        try {
            File f = Helper.getMinecraftDir("battlemusic");
            if (!f.exists()) {
                f.mkdir();
                Assets.populate();
            }
            for (File fi : f.listFiles()) {
                if (!fi.getName().contains(".zip")) continue;
                ZipFile zip = new ZipFile(fi);
                BufferedReader in = new BufferedReader(new InputStreamReader(zip.getInputStream(zip.getEntry("theme.okumeta"))));
                String out = "";
                String t = "";
                while ((t = in.readLine()) != null) {
                    out = out + t + "\u00a7";
                }
                out = out.substring(0, out.length() - 1);
                String[] outargs = out.split("\u00a7");
                in.close();
                this.themes.add(new Theme(fi.getAbsolutePath(), outargs));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.themes.add(new ThemesGetMore());
    }

    public ConfigManager() {
        this.loadThemes();
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void init(FMLPreInitializationEvent event) {
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        this.loadConfig();
        GuiBattleMusicNew.currentSelection = currentPack;
        this.maxVolume = (float)this.config.get("auto", "master", 80.0).getDouble(80.0);
    }

    public void loadConfig() {
        this.config.addCustomCategoryComment("auto", "Better off change this in-game...");
        this.ignoreDragonDistance = this.config.get("main", "ignoreDragonDistance", false).getBoolean(false);
        currentPack = this.config.get("main", "currentPack", 0).getInt();
        this.showFightOverlay = this.config.get("main", "showFightOverlay", false).getBoolean(false);
        this.config.load();
        this.config.save();
    }

    public static String[] getDefaultBiomes() {
        return new String[]{"Ocean", "Plains", "Desert", "Extreme Hills", "Forest", "Taiga", "Swampland", "River", "Hell", "Sky", "FrozenOcean", "FrozenRiver", "Ice Plains", "Ice Mountains", "MushroomIsland", "MushroomIslandShore", "Beach", "DesertHills", "ForestHills", "TaigaHills", "Extreme Hills Edge", "Jungle", "JungleHills"};
    }

    public static HashMap<String, String> biomeThemeFile() {
        if (biomeThemeMap.isEmpty()) {
            for (int i = 0; i < biomesList.length; ++i) {
                biomeThemeMap.put(biomesList[i], biomeThemes[i]);
            }
        }
        return biomeThemeMap;
    }

    public static String[] getDefaultBiomeTracks() {
        String[] out = new String[ConfigManager.getDefaultBiomes().length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = "default.ogg";
        }
        return out;
    }

    public static boolean containsModMob(String s) {
        if (s == null) {
            return false;
        }
        for (String st : ModMobData.getMobTypes()) {
            if (!s.equalsIgnoreCase(st)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsMob(String s) {
        if (s == null) {
            return false;
        }
        for (String st : ConfigManager.getDefaults()) {
            if (!s.equalsIgnoreCase(st)) continue;
            return true;
        }
        return false;
    }

    public static String[] getDefaults() {
        return new String[]{"Creeper", "Skeleton", "Spider", "Zombie", "Slime", "Ghast", "PigZombie", "Enderman", "CaveSpider", "Silverfish", "Blaze", "LavaSlime", "Witch", "EnderDragon", "WitherBoss"};
    }

    public float getMaxVolume() {
        return this.maxVolume - 80.0f;
    }

    static {
        biomeThemeMap = new HashMap();
    }
}

