/*
 * Decompiled with CFR 0.152.
 */
package okushama.battlemusic;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import okushama.battlemusic.Theme;
import okushama.battlemusic.client.GuiBattleMusicNew;
import okushama.battlemusic.client.ProxyClient;
import org.lwjgl.opengl.GL11;

public class Helper {
    public static HashMap<String, Integer> themeTextures = new HashMap();

    public static InputStream getZipStream(Theme t, String par1Str) throws IOException {
        ZipFile z = t.zipFile;
        ZipEntry zipentry = null;
        InputStream out = null;
        try {
            zipentry = z.getEntry(par1Str);
            out = z.getInputStream(zipentry);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return out;
    }

    public static Theme getCurrentTheme() {
        Theme t;
        try {
            t = ProxyClient.config.themes.get(GuiBattleMusicNew.currentSelection);
        }
        catch (Exception e) {
            t = ProxyClient.config.themes.get(0);
            GuiBattleMusicNew.currentSelection = 0;
        }
        return t;
    }

    public static int loadTexture(Theme t, String file) throws Exception {
        if (themeTextures.get(t.name) != null) {
            return themeTextures.get(t.name);
        }
        BufferedImage tex = null;
        InputStream is = Helper.getZipStream(t, file);
        try {
            tex = ImageIO.read(is);
            if (tex == null) {
                throw new Exception("No pack.png for " + t.location);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IntBuffer buf = ByteBuffer.allocateDirect(4).order(ByteOrder.nativeOrder()).asIntBuffer();
        ByteBuffer scratch = ByteBuffer.allocateDirect(4 * tex.getWidth() * tex.getHeight());
        byte[] data = (byte[])tex.getRaster().getDataElements(0, 0, tex.getWidth(), tex.getHeight(), null);
        scratch.clear();
        scratch.put(data);
        scratch.rewind();
        GL11.glGenTextures((IntBuffer)buf);
        System.out.println(tex.getTransparency());
        if (tex.getTransparency() == 1) {
            GL11.glBindTexture((int)3553, (int)buf.get(0));
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexImage2D((int)3553, (int)0, (int)6407, (int)tex.getWidth(), (int)tex.getHeight(), (int)0, (int)6407, (int)5121, (ByteBuffer)scratch);
        } else {
            GL11.glBindTexture((int)3553, (int)buf.get(0));
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)tex.getWidth(), (int)tex.getHeight(), (int)0, (int)6408, (int)5121, (ByteBuffer)scratch);
        }
        themeTextures.put(t.name, buf.get(0));
        return buf.get(0);
    }

    public static File getMinecraftDir(String dir) {
        File f = new File("");
        if (f.getName().contains("jars")) {
            return new File("../eclipse/Minecraft/bin/" + dir);
        }
        return new File(dir);
    }
}

