/*
 * Decompiled with CFR 0.152.
 */
package okushama.battlemusic.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import okushama.battlemusic.Helper;
import okushama.battlemusic.plugin.IPlugin;

public class PluginScanner {
    private static String packageToScan = "okushama.battlemusic.plugin";
    private static String dirToScan = "battlemusic/plugins/";

    private static void log(String msg) {
    }

    public static void populatePluginList(List l) {
        try {
            for (Package p : Package.getPackages()) {
                PluginScanner.log("Found Package " + p.getName());
                if (!p.getName().contains(packageToScan)) continue;
                for (Class<?> c : PluginScanner.getClassesForPackageFromDir(p, dirToScan)) {
                    if (c == null) {
                        PluginScanner.log("Nothing Found!");
                        continue;
                    }
                    if (c.getInterfaces().length <= 0 || c.getInterfaces()[0] != IPlugin.class || c == IPlugin.class) continue;
                    l.add(c.newInstance());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static ArrayList<Class<?>> getClassesForPackageFromDir(Package pkg, String dir) {
        ArrayList classes = new ArrayList();
        String pkgname = pkg.getName();
        String relPath = pkgname.replace('.', '/');
        File resource = null;
        try {
            resource = Helper.getMinecraftDir(dir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (resource == null) {
            throw new RuntimeException("Unexpected problem: No resource for " + relPath);
        }
        PluginScanner.log("Package: '" + pkgname + "' becomes Resource: '" + resource.toString() + "'");
        resource.getPath();
        if (resource.getName().endsWith("jar")) {
            PluginScanner.processJarfile(new File(resource.getPath()), pkgname, classes);
        } else {
            PluginScanner.processDirectory(new File(resource.getPath()), pkgname, classes);
        }
        return classes;
    }

    private static Class<?> loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (Exception e) {
            PluginScanner.log("Unexpected ClassNotFoundException loading class '" + className + "'");
            return null;
        }
    }

    private static void processDirectory(File directory, String pkgname, ArrayList<Class<?>> classes) {
        try {
            PluginScanner.log("Reading Directory '" + directory + "'");
            String fix = directory.getAbsolutePath().replace("%20", " ");
            directory = new File(fix);
            String[] files = directory.list();
            for (int i = 0; i < files.length; ++i) {
                File subdir;
                String fileName = files[i];
                String className = null;
                if (fileName.endsWith(".class")) {
                    className = pkgname + '.' + fileName.substring(0, fileName.length() - 6);
                }
                PluginScanner.log("FileName '" + fileName + "'  =>  class '" + className + "'");
                if (className != null) {
                    classes.add(PluginScanner.loadClass(className));
                }
                if ((subdir = new File(directory, fileName)).isDirectory()) {
                    PluginScanner.processDirectory(subdir, pkgname + '.' + fileName, classes);
                }
                if (!fileName.endsWith(".jar")) continue;
                try {
                    PluginScanner.processJarfile(new File(directory.getAbsolutePath() + File.separator, fileName), pkgname, classes);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void processJarfile(File resource, String pkgname, ArrayList<Class<?>> classes) {
        String resPath;
        String relPath = pkgname.replace('.', '/');
        String jarPath = resPath = resource.getAbsolutePath();
        PluginScanner.log("Reading JAR file: '" + jarPath + "'");
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jarPath);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IOException reading JAR File '" + jarPath + "'", e);
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            String className = null;
            if (entryName.endsWith(".class")) {
                className = entryName.replace('/', '.').replace('\\', '.').replace(".class", "");
            }
            PluginScanner.log("JarEntry '" + entryName + "'  =>  class '" + className + "'");
            if (className == null) continue;
            classes.add(PluginScanner.loadClass(className));
        }
        try {
            jarFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

