/*
 * Decompiled with CFR 0.152.
 */
package okushama.battlemusic;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import okushama.battlemusic.Helper;

public class ModDimensionData {
    private HashMap<Integer, String> dimensionSongs = new HashMap();
    private static final File dir = Helper.getMinecraftDir("battlemusic");
    private static final File file = new File(dir, "mod-dim-support.json");
    private static ModDimensionData instance = null;

    public static String getSoundFileForDimension(int dim) {
        if (instance != null) {
            return ModDimensionData.instance.dimensionSongs.get(dim);
        }
        Gson gson = new Gson();
        FileReader in = null;
        try {
            in = new FileReader(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (in == null) {
            return "overworld.ogg";
        }
        instance = (ModDimensionData)gson.fromJson((Reader)in, ModDimensionData.class);
        if (!ModDimensionData.instance.dimensionSongs.containsKey(dim)) {
            return "overworld.ogg";
        }
        return ModDimensionData.instance.dimensionSongs.get(dim);
    }

    public static void generate() {
        ModDimensionData data = new ModDimensionData();
        HashMap<Integer, String> dimensionSongs = new HashMap<Integer, String>();
        dimensionSongs.put(7, "tf.ogg");
        Gson out = new GsonBuilder().setPrettyPrinting().create();
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fileOut = new FileWriter(file);
            fileOut.write(out.toJson((Object)data));
            fileOut.close();
            System.out.println("CREATED " + file.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

