/*
 * Decompiled with CFR 0.152.
 */
package okushama.battlemusic.client;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import okushama.battlemusic.BiomeMusicTest;
import okushama.battlemusic.client.ConfigManager;
import okushama.battlemusic.client.ProxyClient;
import okushama.battlemusic.core.BattleStream;
import okushama.battlemusic.plugin.IPlugin;

public class TickerClient {
    public BiomeMusicTest biomeTest = new BiomeMusicTest();
    public long ticks = 0L;

    @SubscribeEvent
    public void onClientWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.world == null) {
            this.onNullWorldTick(Minecraft.func_71410_x());
            return;
        }
    }

    public void onNullWorldTick(Minecraft mc) {
        BattleStream stream = ProxyClient.mainStream;
        if (stream.mainMusic != null && !stream.mainMusic.isFinished) {
            stream.volume -= 1.0f;
            if (stream.volume < -70.0f) {
                stream.stop(false);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        World world = event.player.field_70170_p;
        EntityPlayer player = event.player;
        if (event.phase == TickEvent.Phase.END) {
            if (this.ticks % 4L == 0L) {
                try {
                    BattleStream stream = ProxyClient.mainStream;
                    for (IPlugin plugin : ProxyClient.plugins) {
                        plugin.onClientTick(Minecraft.func_71410_x(), world);
                        if (!plugin.breakCoreLoop()) continue;
                        return;
                    }
                    if (player.field_71075_bZ.field_75098_d) {
                        // empty if block
                    }
                    if (player.field_71093_bK == 1) {
                        List ents = world.field_72996_f;
                        boolean hasDragon = false;
                        for (Entity ent : ents) {
                            if (!ConfigManager.containsMob(EntityList.func_75621_b((Entity)ent)) && !ConfigManager.containsModMob(ent.getClass().getName()) || !(ent instanceof EntityDragon)) continue;
                            hasDragon = true;
                            if (!ProxyClient.config.ignoreDragonDistance) {
                                stream.volume(ProxyClient.config.getMaxVolume() - (float)player.func_70068_e(ent) / 1000.0f);
                                continue;
                            }
                            stream.volumeUp();
                        }
                        if (hasDragon) {
                            stream.play("dragon.ogg", true);
                            if (ProxyClient.config.ignoreDragonDistance) {
                                stream.volume = ProxyClient.config.getMaxVolume();
                            }
                            if (stream.volume < -70.0f) {
                                stream.volume = -70.0f;
                            }
                        } else if (stream.mainMusic != null) {
                            stream.volume -= 1.0f;
                            if (stream.volume < -70.0f) {
                                // empty if block
                            }
                        }
                        return;
                    }
                    String music = "overworld.ogg";
                    if (player.field_71093_bK == -1) {
                        music = "nether.ogg";
                    }
                    List ents = world.field_72996_f;
                    int closest = -1;
                    float lowestDist = 200.0f;
                    float minDist = 200.0f;
                    boolean hasWither = false;
                    for (Entity ent : ents) {
                        if (!(ent instanceof EntityWither)) continue;
                        hasWither = true;
                        stream.play("wither.ogg", true);
                        stream.volume(ProxyClient.config.getMaxVolume() - (float)player.func_70068_e(ent) / 250.0f);
                        return;
                    }
                    for (int i = 0; i < ents.size(); ++i) {
                        EntityPigZombie pz;
                        int s;
                        Entity ent;
                        ent = (Entity)ents.get(i);
                        if (!ConfigManager.containsMob(EntityList.func_75621_b((Entity)ent)) && !ConfigManager.containsModMob(ent.getClass().getName()) || ent.field_70128_L || ent instanceof EntityPigZombie && (s = ((Integer)ObfuscationReflectionHelper.getPrivateValue(EntityPigZombie.class, (Object)(pz = (EntityPigZombie)ent), (String[])new String[]{"angerLevel", "bs"})).intValue()) == 0 || !(ent instanceof EntityLivingBase) || !((EntityLivingBase)ent).func_70685_l((Entity)player) || !(ent.func_70068_e((Entity)player) < (double)lowestDist) || !(ent.func_70068_e((Entity)player) < (double)minDist)) continue;
                        lowestDist = ent.func_70032_d((Entity)player);
                        closest = i;
                    }
                    if (closest > -1) {
                        EntityLivingBase ent = (EntityLivingBase)ents.get(closest);
                        if (ent.func_70068_e((Entity)player) < 200.0) {
                            stream.volumeUp();
                            stream.play(music, true);
                        } else {
                            stream.fadeToStop();
                        }
                    } else {
                        if (stream.mainMusic == null) {
                            return;
                        }
                        if (!stream.mainMusic.isFinished) {
                            stream.fadeToStop();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++this.ticks;
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            // empty if block
        }
    }
}

